package com.biz.crm.mdm.business.product.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.product.sdk.dto.*;
import com.biz.crm.mdm.business.product.sdk.vo.MaterialProductVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 商品主数据Vo接口
 *
 * @author sunx
 * @since 2021-10-13 17:36:03
 */
public interface ProductVoService {

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  default ProductVo create(ProductDto dto) {
    return null;
  }

  /**
   * 更新
   *
   * @param dto
   * @return
   */
  default ProductVo update(ProductDto dto) {
    return null;
  }

  /**
   * 可选商品下拉
   *
   * @param keyword
   * @return
   */
  default List<ProductVo> findSelectByKeyword(String keyword) {
    return Lists.newLinkedList();
  }

  /**
   * 获取物料对应的关联商品编码集合，及商品对应层级及其上级层级编码集合
   *
   * @param materialCode
   * @return
   */
  default MaterialProductVo findMaterialProductVoByMaterialCode(String materialCode) {
    return null;
  }

  /**
   * 根据商品层级获取对应的商品的主信息
   *
   * @param productLevelCodeList
   * @return
   */
  default List<ProductVo> findByProductLevelCodes(List<String> productLevelCodeList) {
    return Lists.newLinkedList();
  }

  /**
   * 获取商品对应层级及其上级层级编码集合
   *
   * @param productCodeSet
   * @return
   */
  default Set<String> findParentLevelCodeSetByProductCodes(Set<String> productCodeSet) {
    return Sets.newHashSet();
  }

  /**
   * 根据ProductQueryDto获取商品主信息
   *
   * @param dto
   * @return
   */
  default List<ProductVo> findByProductQueryDto(ProductQueryDto dto) {
    return Lists.newLinkedList();
  }

  /**
   * 根据ProductQueryDto获取商品主信息
   *
   * @param dto
   * @return
   */
  default List<ProductVo> findByQueryDto(ProductQueryDto dto) {
    return Lists.newLinkedList();
  }

  /**
   * 根据id或编码集合获取商品详情集合
   *
   * @param ids
   * @param productCodes
   * @return
   */
  default List<ProductVo> findDetailsByIdsOrProductCodes(
      List<String> ids, List<String> productCodes) {
    return Lists.newLinkedList();
  }

  /**
   * 根据商品商品编码集合获取商品主信息+层级信息
   *
   * @param productCodeList
   * @return
   */
  default List<ProductVo> findMainDetailsByProductCodes(List<String> productCodeList) {
    return Lists.newLinkedList();
  }

  /**
   * 根据ProductDetailQueryDto获取商品详情信息
   *
   * @param dto
   * @return
   */
  default List<ProductVo> findDetailsByProductDetailQueryDto(ProductDetailQueryDto dto) {
    return Lists.newLinkedList();
  }

  /**
   * 根据层级获取层级及下级所有的上架且启用的产品集合
   *
   * @param productLevelCodes
   * @return k-产品编码，v-关联层级对应的降维码集合
   */
  default Map<String, String> findAllowSaleProductByProductLevelCodes(Set<String> productLevelCodes) {
    return Maps.newHashMap();
  }

  /**
   * 根据ProductPaginationDto获取商品分页信息
   *
   * @param pageable 分页参数
   * @param dto 查询对象
   * @return Page<ProductVo>
   */
  default Page<ProductVo> findByConditions(Pageable pageable, ProductPaginationDto dto) {
    return new Page<>(pageable.getPageNumber(), pageable.getPageSize());
  }


  List<ProductVo> findProductByIds(ProductSearchDto dto);
}
