package com.biz.crm.mdm.business.product.spu.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.spu.feign.feign.internal.ProductSpuRelateSkuVoServiceFeignImpl;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 商品spu关联sku feign
 *
 * @author sunx
 * @date 2021/12/3
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = ProductSpuRelateSkuVoServiceFeignImpl.class)
public interface ProductSpuRelateSkuVoServiceFeign {

  /**
   * 根据spuCode集合获取关联sku信息
   *
   * @param spuCodeList
   * @return
   */
  @GetMapping(value = {"/v1/productSpu/productSpuRelateSku/findBySpuCodes"})
  Result<List<ProductSpuRelateSkuVo>> findBySpuCodes(
      @RequestParam("spuCodeList") List<String> spuCodeList);

  /**
   * 根据spuCode集合获取关联sku信息
   *
   * @param productCodeList
   * @return
   */
  @GetMapping(value = {"/v1/productSpu/productSpuRelateSku/findByProductCodes"})
  Result<List<ProductSpuRelateSkuVo>> findByProductCodes(
      @RequestParam("productCodeList") List<String> productCodeList);
}
