package com.biz.crm.mdm.business.product.spu.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.spu.feign.feign.ProductSpuRelateSkuVoServiceFeign;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import feign.hystrix.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 商品spu关联sku feign实现
 *
 * @author sunx
 * @date 2021/12/3
 */
@Component
public class ProductSpuRelateSkuVoServiceFeignImpl
    implements FallbackFactory<ProductSpuRelateSkuVoServiceFeign> {

  @Override
  public ProductSpuRelateSkuVoServiceFeign create(Throwable cause) {
    return new ProductSpuRelateSkuVoServiceFeign() {
      @Override
      public Result<List<ProductSpuRelateSkuVo>> findBySpuCodes(List<String> spuCodeList) {
        throw new UnsupportedOperationException("根据spuCode集合获取关联sku信息熔断");
      }

      @Override
      public Result<List<ProductSpuRelateSkuVo>> findByProductCodes(List<String> productCodeList) {
        throw new UnsupportedOperationException("根据skuCode集合获取关联sku信息熔断");
      }
    };
  }
}
