package com.biz.crm.mdm.business.product.spu.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.spu.feign.feign.ProductSpuVoServiceFeign;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import feign.hystrix.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 商品spu feign实现
 *
 * @author sunx
 * @date 2021/12/3
 */
@Component
public class ProductSpuVoServiceFeignImpl implements FallbackFactory<ProductSpuVoServiceFeign> {

  @Override
  public ProductSpuVoServiceFeign create(Throwable throwable) {
    return new ProductSpuVoServiceFeign() {
      @Override
      public Result<List<ProductSpuVo>> findBySpuCodes(List<String> spuCodeList) {
        throw new UnsupportedOperationException("根据spuCode集合获取spu主信息熔断");
      }

      @Override
      public Result<List<ProductSpuVo>> findDetailsBySpuCodes(List<String> spuCodeList) {
        throw new UnsupportedOperationException("根据spuCode集合获取spu全量关联明细熔断");
      }

      @Override
      public Result<Map<String, List<ProductSpuVo>>> findRelateSpuMapByProductCodes(
          List<String> productCodeList) {
        throw new UnsupportedOperationException("根据商品编码获取关联的spu主信息");
      }
    };
  }
}
