package com.biz.crm.mdm.business.product.spu.feign.service.internal;

import com.biz.crm.mdm.business.product.spu.feign.feign.ProductSpuVoServiceFeign;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 商品spu信息sdk实现
 *
 * @author sunx
 * @date 2021/12/3
 */
@Service
public class ProductSpuVoServiceImpl implements ProductSpuVoService {

  @Autowired(required = false) private ProductSpuVoServiceFeign productSpuVoServiceFeign;

  @Override
  public List<ProductSpuVo> findBySpuCodes(List<String> spuCodeList) {
    spuCodeList = Optional.ofNullable(spuCodeList).orElse(Lists.newLinkedList());
    return this.productSpuVoServiceFeign.findBySpuCodes(spuCodeList).getResult();
  }

  @Override
  public List<ProductSpuVo> findDetailsBySpuCodes(List<String> spuCodeList) {
    spuCodeList = Optional.ofNullable(spuCodeList).orElse(Lists.newLinkedList());
    return this.productSpuVoServiceFeign.findDetailsBySpuCodes(spuCodeList).getResult();
  }


  public Map<String, List<ProductSpuVo>> findRelateSpuMapByProductCodes(
      List<String> productCodeList) {
    productCodeList = Optional.ofNullable(productCodeList).orElse(Lists.newLinkedList());
    return this.productSpuVoServiceFeign
        .findRelateSpuMapByProductCodes(productCodeList)
        .getResult();
  }
}
