package com.biz.crm.mdm.business.product.spu.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.spu.feign.feign.internal.FavoriteProductVoServiceFeignImpl;
import com.biz.crm.mdm.business.product.spu.sdk.vo.FavoriteProductVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 *
 * @author hefan
 * @date 2022/05/16
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = FavoriteProductVoServiceFeignImpl.class)
public interface FavoriteProductVoServiceFeign {

  /**
   * 根据spuCode集合获取关联sku的商品信息
   * @param spuCodeList
   * @return
   */
  @GetMapping(value = {"/v1/productSpu/productSpuRelateSku/findDetailBySpuCodes"})
  Result<List<FavoriteProductVO>> findDetailBySpuCodes(@RequestParam("spuCodeList") List<String> spuCodeList);

}
