package com.biz.crm.mdm.business.product.spu.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.spu.feign.feign.internal.ProductSpuVoServiceFeignImpl;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 商品spu feign
 *
 * @author sunx
 * @date 2021/12/3
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = ProductSpuVoServiceFeignImpl.class)
public interface ProductSpuVoServiceFeign {

  /**
   * 根据spuCode集合获取spu主信息
   *
   * @param spuCodeList
   * @return
   */
  @GetMapping(value = {"/v1/productSpu/productSpu/findBySpuCodes"})
  Result<List<ProductSpuVo>> findBySpuCodes(@RequestParam("spuCodeList") List<String> spuCodeList);

  /**
   * 根据spuCode集合获取spu全量关联明细
   *
   * @param spuCodeList
   * @return
   */
  @GetMapping(value = {"/v1/productSpu/productSpu/findDetailsBySpuCodes"})
  Result<List<ProductSpuVo>> findDetailsBySpuCodes(@RequestParam("spuCodeList") List<String> spuCodeList);

  /**
   * 根据商品编码获取关联的spu主信息
   *
   * @param productCodeList
   * @return
   */
  @GetMapping(value = {"/v1/productSpu/productSpu/findRelateSpuMapByProductCodes"})
  Result<Map<String, List<ProductSpuVo>>> findRelateSpuMapByProductCodes(
      @RequestParam("productCodeList") List<String> productCodeList);
}
