package com.biz.crm.mdm.business.product.spu.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.spu.feign.feign.internal.AllowSaleListSpuVoFeignImpl;
import com.biz.crm.mdm.business.product.spu.sdk.dto.AllowSaleListSpuPaginationDto;
import com.biz.crm.mdm.business.product.spu.sdk.vo.AllowSaleListSpuVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author sunx
 * @date 2021/12/6
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = AllowSaleListSpuVoFeignImpl.class)
public interface AllowSaleListSpuVoFeign {

  /**
   * 商品SPU管理电商可购清单分页数据
   *
   * @param dto
   * @return
   */
  @PostMapping(value = {"/v1/product/spu/report/onRequestByAllowSaleListSpuPaginationDto"})
  Result<Page<AllowSaleListSpuVo>> onRequestByAllowSaleListSpuPaginationDto(
      @RequestBody AllowSaleListSpuPaginationDto dto);

  /**
   * 商品SPU管理电商可购清单分页数据 精准搜索
   *
   * @param dto
   * @return
   */
  @PostMapping(value = {"/v1/product/spu/report/onRequestByAllowSaleListSpuPrecisePaginationDto"})
  Result<Page<AllowSaleListSpuVo>> onRequestByAllowSaleListSpuPrecisePaginationDto(
      AllowSaleListSpuPaginationDto dto);
}
