package com.biz.crm.mdm.business.product.spu.feign.service.internal;

import com.biz.crm.mdm.business.product.spu.feign.feign.ProductSpuRelateSkuVoServiceFeign;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuRelateSkuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * spu关联sku sdk实现
 *
 * @author sunx
 * @date 2021/12/3
 */
@Service
public class ProductSpuRelateSkuVoServiceImpl implements ProductSpuRelateSkuVoService {

  @Autowired(required = false) private ProductSpuRelateSkuVoServiceFeign productSpuRelateSkuVoServiceFeign;

  @Override
  public List<ProductSpuRelateSkuVo> findBySpuCodes(List<String> spuCodeList) {
    spuCodeList = Optional.ofNullable(spuCodeList).orElse(Lists.newLinkedList());
    return this.productSpuRelateSkuVoServiceFeign.findBySpuCodes(spuCodeList).checkFeignResult();
  }

  @Override
  public List<ProductSpuRelateSkuVo> findByProductCodes(List<String> productCodeList) {

    return this.productSpuRelateSkuVoServiceFeign.findByProductCodes(productCodeList).checkFeignResult();
  }

}
