/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1spu\u7ba1\u7406: ProductSpuVo: \u5546\u54c1spu\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/productSpu/productSpu"})
public class ProductSpuVoController {
    private static final Logger log = LoggerFactory.getLogger(ProductSpuVoController.class);
    @Autowired(required=false)
    private ProductSpuVoService productSpuVoService;

    @ApiOperation(value="\u6839\u636espuCode\u96c6\u5408\u83b7\u53d6spu\u4e3b\u4fe1\u606f")
    @GetMapping(value={"/findBySpuCodes"})
    public Result<List<ProductSpuVo>> findBySpuCodes(@RequestParam(value="spuCodeList") List<String> spuCodeList) {
        try {
            List list = this.productSpuVoService.findBySpuCodes(spuCodeList);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636espuCode\u96c6\u5408\u83b7\u53d6spu\u5168\u91cf\u5173\u8054\u660e\u7ec6")
    @GetMapping(value={"/findDetailsBySpuCodes"})
    public Result<List<ProductSpuVo>> findDetailsBySpuCodes(@RequestParam(value="spuCodeList") List<String> spuCodeList) {
        try {
            List list = this.productSpuVoService.findDetailsBySpuCodes(spuCodeList);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5546\u54c1\u7f16\u7801\u83b7\u53d6\u5173\u8054\u7684spu\u4e3b\u4fe1\u606f")
    @GetMapping(value={"/findRelateSpuMapByProductCodes"})
    public Result<Map<String, List<ProductSpuVo>>> findRelateSpuMapByProductCodes(@RequestParam(value="productCodeList") List<String> productCodeList) {
        try {
            Map map = this.productSpuVoService.findRelateSpuMapByProductCodes(productCodeList);
            return Result.ok((Object)map);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

