/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpu;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuMedia;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuRelateSku;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuRepository;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuMediaService;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuRelateSkuService;
import com.biz.crm.mdm.business.product.spu.sdk.enums.MediaTypeEnum;
import com.biz.crm.mdm.business.product.spu.sdk.service.FavoriteProductVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.FavoriteProductVO;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class FavoriteProductVoServiceImpl
implements FavoriteProductVoService {
    @Autowired(required=false)
    private ProductSpuRepository productSpuRepository;
    @Autowired(required=false)
    private ProductSpuRelateSkuService productSpuRelateSkuService;
    @Autowired(required=false)
    private ProductSpuMediaService productSpuMediaService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<FavoriteProductVO> findDetailBySpuCodes(List<String> spuCodeList) {
        if (CollectionUtils.isEmpty(spuCodeList)) {
            return Lists.newLinkedList();
        }
        List<ProductSpu> list = this.productSpuRepository.findBySpuCodes(spuCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        List<String> existsSpuCodeList = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).map(ProductSpu::getSpuCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(existsSpuCodeList)) {
            return Lists.newLinkedList();
        }
        HashMap mapSku = Maps.newHashMap();
        Map<Object, Object> mapMedia = Maps.newHashMap();
        ArrayList result = Lists.newArrayList();
        List<ProductSpuRelateSku> skuList = this.productSpuRelateSkuService.findBySpuCodes(existsSpuCodeList);
        List<ProductSpuMedia> mediaList = this.productSpuMediaService.findBySpuCodes(spuCodeList);
        if (CollectionUtils.isNotEmpty(skuList)) {
            List productCodes = skuList.stream().map(ProductSpuRelateSku::getProductCode).collect(Collectors.toList());
            List productVos = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodes);
            existsSpuCodeList.forEach(spu -> {
                ArrayList skus = Lists.newArrayList();
                skuList.forEach(sku -> {
                    if (spu.equals(sku.getSpuCode())) {
                        productVos.forEach(product -> {
                            if (sku.getProductCode().equals(product.getProductCode())) {
                                FavoriteProductVO productFavoriteVO = (FavoriteProductVO)this.nebulaToolkitService.copyObjectByBlankList(product, FavoriteProductVO.class, HashSet.class, ArrayList.class, new String[0]);
                                skus.add(productFavoriteVO);
                            }
                        });
                    }
                });
                mapSku.put(spu, skus);
            });
        }
        if (CollectionUtils.isNotEmpty(mediaList)) {
            mapMedia = mediaList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).collect(Collectors.groupingBy(ProductSpuMedia::getSpuCode));
        }
        for (ProductSpu item : list) {
            FavoriteProductVO favoriteVO = new FavoriteProductVO();
            favoriteVO.setProductCode(item.getSpuCode());
            favoriteVO.setProductName(item.getSpuName());
            favoriteVO.setSkus((List)mapSku.get(item.getSpuCode()));
            List mediaList1 = (List)mapMedia.get(item.getSpuCode());
            if (CollectionUtils.isNotEmpty((Collection)mediaList1)) {
                Map<String, List<ProductSpuMedia>> curMap = mediaList1.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getType())).collect(Collectors.groupingBy(ProductSpuMedia::getType));
                favoriteVO.setPrimaryPictureUrl(CollectionUtils.isNotEmpty((Collection)curMap.get(MediaTypeEnum.PICTURE.getCode())) ? curMap.get(MediaTypeEnum.PICTURE.getCode()).get(0).getUrlAddress() : null);
            }
            result.add(favoriteVO);
        }
        return result;
    }
}

