/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpu;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuRepository;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuService;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuRelateSkuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ProductSpuVoServiceImpl
implements ProductSpuVoService {
    @Autowired(required=false)
    private ProductSpuRepository productSpuRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProductSpuService productSpuService;
    @Autowired(required=false)
    private ProductSpuRelateSkuVoService productSpuRelateSkuVoService;

    public List<ProductSpuVo> findBySpuCodes(List<String> spuCodeList) {
        if (CollectionUtils.isEmpty(spuCodeList)) {
            return Lists.newLinkedList();
        }
        List<ProductSpu> list = this.productSpuRepository.findBySpuCodes(spuCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ProductSpu.class, ProductSpuVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ProductSpuVo> findDetailsBySpuCodes(List<String> spuCodeList) {
        if (CollectionUtils.isEmpty(spuCodeList)) {
            return Lists.newLinkedList();
        }
        List<ProductSpu> list = this.productSpuService.findDetailsBySpuCodes(spuCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ProductSpu.class, ProductSpuVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Map<String, List<ProductSpuVo>> findRelateSpuMapByProductCodes(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return Maps.newHashMap();
        }
        List list = this.productSpuRelateSkuVoService.findByProductCodes(productCodeList);
        Set spuCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).map(ProductSpuRelateSkuVo::getSpuCode).collect(Collectors.toSet());
        Map map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getSpuCode(), a.getProductCode()})).collect(Collectors.groupingBy(ProductSpuRelateSkuVo::getProductCode, Collectors.mapping(ProductSpuRelateSkuVo::getSpuCode, Collectors.toList())));
        if (CollectionUtils.isEmpty(spuCodeSet)) {
            return Maps.newHashMap();
        }
        List<ProductSpu> spuList = this.productSpuRepository.findBySpuCodes(Lists.newArrayList(spuCodeSet));
        List spuVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(spuList, ProductSpu.class, ProductSpuVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map mapSpuVo = spuVoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).collect(Collectors.toMap(ProductSpuVo::getSpuCode, Function.identity(), (a, b) -> a));
        HashMap re = Maps.newHashMap();
        for (Map.Entry item : map.entrySet()) {
            LinkedList curList = Lists.newLinkedList();
            for (String spuCode : item.getValue()) {
                if (!mapSpuVo.keySet().contains(spuCode)) continue;
                curList.add(mapSpuVo.get(spuCode));
            }
            if (!CollectionUtils.isNotEmpty((Collection)curList)) continue;
            re.put(item.getKey(), curList);
        }
        return re;
    }
}

