/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTagMapping;
import com.biz.crm.mdm.business.product.spu.local.mapper.ProductSpuTagMappingMapper;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagMappingPaginationDto;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagMappingQueryDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ProductSpuTagMappingRepository
extends ServiceImpl<ProductSpuTagMappingMapper, ProductSpuTagMapping> {
    public Page<ProductSpuTagMapping> findByConditions(Page<ProductSpuTagMapping> page, ProductSpuTagMappingPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((ProductSpuTagMappingMapper)this.baseMapper).findByConditions(page, dto);
    }

    public Page<ProductSpuTagMapping> findExcludeByConditions(Page<ProductSpuTagMapping> page, ProductSpuTagMappingPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((ProductSpuTagMappingMapper)this.baseMapper).findExcludeByConditions(page, dto);
    }

    public void deleteByTagCodes(Set<String> tagCodes) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.in(ProductSpuTagMapping::getTagCode, tagCodes);
        lambdaQuery.eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        ((ProductSpuTagMappingMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
    }

    public void deleteBySupCodes(Set<String> spuCodes) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        lambdaQuery.in(ProductSpuTagMapping::getSpuCode, spuCodes);
        ((ProductSpuTagMappingMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
    }

    public List<ProductSpuTagMapping> findByProductSpuTagMappingQueryDto(ProductSpuTagMappingQueryDto dto) {
        return ((ProductSpuTagMappingMapper)this.baseMapper).findByProductSpuTagMappingQueryDto(dto);
    }

    public void deleteByTagCodeAndSupCodes(String tagCode, Set<String> spuCodeSet) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        lambdaQuery.eq(ProductSpuTagMapping::getTagCode, (Object)tagCode);
        lambdaQuery.in(ProductSpuTagMapping::getSpuCode, spuCodeSet);
        ((ProductSpuTagMappingMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
    }

    public void deleteByItemKeys(Set<String> itemKeys) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        for (List item : Lists.partition((List)Lists.newArrayList(itemKeys), (int)500)) {
            lambdaQuery.in(ProductSpuTagMapping::getItemKey, (Collection)item);
            lambdaQuery.eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
            ((ProductSpuTagMappingMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
        }
    }
}

