package com.biz.crm.mdm.business.product.spu.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品spu标签关联关系表
 *
 * @author zengxingwang
 * @since 2021-12-02 17:07:23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_product_spu_tag_mapping")
@Table(
    name = "mdm_product_spu_tag_mapping",
    indexes = {
      @Index(
          name = "mdm_product_spu_tag0",
          columnList = "tenant_code,tag_code,spu_code",
          unique = true),
      @Index(name = "mdm_product_spu_tag1", columnList = "item_key"),
    })
@ApiModel(value = "ProductSpuTagMapping", description = "商品spu标签关联关系表")
@org.hibernate.annotations.Table(
    appliesTo = "mdm_product_spu_tag_mapping",
    comment = "商品spu标签关联关系表")
public class ProductSpuTagMapping extends TenantEntity {

  /** 商品spu编码 */
  @ApiModelProperty("商品spu编码")
  @TableField(value = "spu_code")
  @Column(name = "spu_code", length = 64, columnDefinition = "varchar(64) COMMENT '商品spu编码'")
  private String spuCode;

  /** 标签编码 */
  @ApiModelProperty("标签编码")
  @TableField(value = "tag_code")
  @Column(name = "tag_code", length = 64, columnDefinition = "varchar(64) COMMENT '标签编码'")
  private String tagCode;

  /** 行唯一约束 */
  @ApiModelProperty("行唯一约束，tenant_code:tag_code:spu_code")
  @TableField(value = "item_key")
  @Column(name = "item_key", length = 200, columnDefinition = "varchar(200) COMMENT '行唯一约束'")
  private String itemKey;

  /** 标签名称 */
  @ApiModelProperty("标签名称")
  @TableField(exist = false)
  @Transient
  private String tagName;

  /** spu名称 */
  @ApiModelProperty("spu名称")
  @TableField(exist = false)
  @Transient
  private String spuName;

  /** 上下架状态 */
  @ApiModelProperty("上下架状态")
  @TableField(exist = false)
  @Transient
  private String isShelf;

  /** 关联的商品sku数量 */
  @TableField(exist = false)
  @Transient
  @ApiModelProperty("关联的商品sku数量")
  private Long productQuantity;
}
