package com.biz.crm.mdm.business.product.spu.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpu;
import com.biz.crm.mdm.business.product.spu.local.mapper.ProductSpuMapper;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuPaginationDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 商品spu信息(repository)
 *
 * @author sunx
 * @date 2021-12-02 16:06:48
 */
@Component
public class ProductSpuRepository extends ServiceImpl<ProductSpuMapper, ProductSpu> {

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<ProductSpu> findByConditions(Page<ProductSpu> page, ProductSpuPaginationDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param idList
   * @return
   */
  public List<ProductSpu> findByIds(List<String> idList) {
    return this.lambdaQuery().in(ProductSpu::getId, idList).list();
  }

  /**
   * 根据spuCode集合获取详情集合
   *
   * @param spuCodeList
   * @return
   */
  public List<ProductSpu> findBySpuCodes(List<String> spuCodeList) {
    return this.lambdaQuery().in(ProductSpu::getSpuCode, spuCodeList).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(ProductSpu::getId, ids)
        .set(ProductSpu::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(ProductSpu::getId, ids)
        .set(ProductSpu::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  public Integer countByRuleCode(String spuCode) {
    return this.lambdaQuery()
        .eq(ProductSpu::getTenantCode, TenantUtils.getTenantCode())
        .eq(ProductSpu::getSpuCode, spuCode)
        .count();
  }

  /**
   * 更新上下加状态
   *
   * @param ids
   * @param code
   */
  public void updateIsShelfByIds(List<String> ids, String code) {
    this.lambdaUpdate().in(ProductSpu::getId, ids).set(ProductSpu::getIsShelf, code).update();
  }

  /**
   * 更新上下加状态
   *
   * @param spuCodeList
   * @param code
   */
  public void updateIsShelfBySpuCodes(List<String> spuCodeList, String code) {
    this.lambdaUpdate()
        .eq(ProductSpu::getTenantCode, TenantUtils.getTenantCode())
        .in(ProductSpu::getSpuCode, spuCodeList)
        .set(ProductSpu::getIsShelf, code)
        .update();
  }
}
