package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuIntroduction;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuIntroductionRepository;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuIntroductionService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 商品spu介绍详情(ProductSpuIntroduction)表服务实现类
 *
 * @author sunx
 * @date 2021-12-02 16:07:22
 */
@Slf4j
@Service("productSpuIntroductionService")
public class ProductSpuIntroductionServiceImpl implements ProductSpuIntroductionService {

  @Autowired(required = false) private ProductSpuIntroductionRepository productSpuIntroductionRepository;

  @Override
  @Transactional
  public void save(ProductSpuIntroduction introduction, String spuCode) {
    Validate.notBlank(spuCode, "spuCode不能为空");
    this.productSpuIntroductionRepository.deleteBySpuCodes(Lists.newArrayList(spuCode));
    if (Objects.isNull(introduction)) {
      return;
    }
    introduction.setSpuCode(spuCode);
    introduction.setTenantCode(TenantUtils.getTenantCode());
    this.productSpuIntroductionRepository.save(introduction);
  }

  @Override
  public List<ProductSpuIntroduction> findBySpuCodes(List<String> spuCodeList) {
    if (CollectionUtils.isEmpty(spuCodeList)) {
      return Lists.newLinkedList();
    }
    return this.productSpuIntroductionRepository.findBySpuCodes(spuCodeList);
  }
}
