package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuRelateSku;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuRelateSkuRepository;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuRelateSkuService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 商品spu关联的sku信息(ProductSpuRelateSku)表服务实现类
 *
 * @author sunx
 * @date 2021-12-02 16:08:19
 */
@Slf4j
@Service("productSpuRelateSkuService")
public class ProductSpuRelateSkuServiceImpl implements ProductSpuRelateSkuService {

  @Autowired(required = false) private ProductSpuRelateSkuRepository productSpuRelateSkuRepository;

  @Autowired(required = false) private ProductVoService productVoService;

  @Override
  @Transactional
  public void saveBatch(List<ProductSpuRelateSku> productList, String spuCode) {
    Validate.notBlank(spuCode, "spuCode不能为空");
    this.productSpuRelateSkuRepository.deleteBySpuCodes(Lists.newArrayList(spuCode));
    if (CollectionUtils.isEmpty(productList)) {
      return;
    }
    int sort = 1;
    for (ProductSpuRelateSku a : productList) {
      a.setSpuCode(spuCode);
      a.setTenantCode(TenantUtils.getTenantCode());
      a.setSort(++sort);
    }
    this.productSpuRelateSkuRepository.saveBatch(productList);
  }

  @Override
  public List<ProductSpuRelateSku> findBySpuCodes(List<String> spuCodeList) {
    if (CollectionUtils.isEmpty(spuCodeList)) {
      return Lists.newLinkedList();
    }
    List<ProductSpuRelateSku> list = this.productSpuRelateSkuRepository.findBySpuCodes(spuCodeList);
    if (CollectionUtils.isEmpty(list)) {
      return list;
    }
    List<String> skuCodeList =
        list.stream()
            .filter(a -> StringUtils.isNotBlank(a.getProductCode()))
            .map(ProductSpuRelateSku::getProductCode)
            .collect(Collectors.toList());
    List<ProductVo> skuList = productVoService.findDetailsByIdsOrProductCodes(null, skuCodeList);
    if (CollectionUtils.isEmpty(skuList)) {
      return list;
    }
    Map<String, ProductVo> mapSku =
        skuList.stream()
            .filter(a -> StringUtils.isNotBlank(a.getProductCode()))
            .collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (a, b) -> a));
    list.forEach(
        a -> {
          ProductVo productVo = mapSku.get(a.getProductCode());
          if (Objects.nonNull(productVo)) {
            a.setIsShelf(productVo.getIsShelf());
            a.setProductLevelName(productVo.getProductLevelName());
            a.setProductName(productVo.getProductName());
            a.setProductType(productVo.getProductType());
            a.setSpec(productVo.getSpec());
          }
        });
    return list;
  }

  @Override
  public List<ProductSpuRelateSku> findSupCodesByproductCodesAndIsShelf(
      Set<String> productCodeSet, String isShelf) {
    if (CollectionUtils.isEmpty(productCodeSet) || StringUtils.isBlank(isShelf)) {
      return Lists.newLinkedList();
    }
    return this.productSpuRelateSkuRepository.findSupCodesByproductCodesAndIsShelf(
        productCodeSet, isShelf);
  }
}
