/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpu;
import com.biz.crm.mdm.business.product.spu.local.mapper.ProductSpuMapper;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuPaginationDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ProductSpuRepository
extends ServiceImpl<ProductSpuMapper, ProductSpu> {
    public Page<ProductSpu> findByConditions(Page<ProductSpu> page, ProductSpuPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((ProductSpuMapper)this.baseMapper).findByConditions(page, dto);
    }

    public List<ProductSpu> findByIds(List<String> idList) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, idList)).list();
    }

    public List<ProductSpu> findBySpuCodes(List<String> spuCodeList) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(ProductSpu::getSpuCode, spuCodeList)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public Integer countByRuleCode(String spuCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ProductSpu::getSpuCode, (Object)spuCode)).count();
    }

    public void updateIsShelfByIds(List<String> ids, String code) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(ProductSpu::getIsShelf, (Object)code)).update();
    }

    public void updateIsShelfBySpuCodes(List<String> spuCodeList, String code) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ProductSpu::getSpuCode, spuCodeList)).set(ProductSpu::getIsShelf, (Object)code)).update();
    }
}

