/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuIntroduction;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuIntroductionRepository;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuIntroductionService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productSpuIntroductionService")
public class ProductSpuIntroductionServiceImpl
implements ProductSpuIntroductionService {
    private static final Logger log = LoggerFactory.getLogger(ProductSpuIntroductionServiceImpl.class);
    @Autowired(required=false)
    private ProductSpuIntroductionRepository productSpuIntroductionRepository;

    @Override
    @Transactional
    public void save(ProductSpuIntroduction introduction, String spuCode) {
        Validate.notBlank((CharSequence)spuCode, (String)"spuCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productSpuIntroductionRepository.deleteBySpuCodes(Lists.newArrayList((Object[])new String[]{spuCode}));
        if (Objects.isNull((Object)introduction)) {
            return;
        }
        introduction.setSpuCode(spuCode);
        introduction.setTenantCode(TenantUtils.getTenantCode());
        this.productSpuIntroductionRepository.save((Object)introduction);
    }

    @Override
    public List<ProductSpuIntroduction> findBySpuCodes(List<String> spuCodeList) {
        if (CollectionUtils.isEmpty(spuCodeList)) {
            return Lists.newLinkedList();
        }
        return this.productSpuIntroductionRepository.findBySpuCodes(spuCodeList);
    }
}

