/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpu;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuIntroduction;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuMedia;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuRelateSku;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTag;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTagMapping;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuRepository;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuTagMappingRepository;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuIntroductionService;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuMediaService;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuRelateSkuService;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuService;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuTagMappingService;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuPaginationDto;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagMappingQueryDto;
import com.biz.crm.mdm.business.product.spu.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.spu.sdk.enums.MediaTypeEnum;
import com.biz.crm.mdm.business.product.spu.sdk.event.ProductSpuEventListener;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productSpuService")
public class ProductSpuServiceImpl
implements ProductSpuService {
    private static final Logger log = LoggerFactory.getLogger(ProductSpuServiceImpl.class);
    @Autowired(required=false)
    private ProductSpuRepository productSpuRepository;
    @Autowired(required=false)
    @Lazy
    private List<ProductSpuEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProductSpuTagMappingService productSpuTagMappingService;
    @Autowired(required=false)
    private ProductSpuRelateSkuService productSpuRelateSkuService;
    @Autowired(required=false)
    private ProductSpuMediaService productSpuMediaService;
    @Autowired(required=false)
    private ProductSpuIntroductionService productSpuIntroductionService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ProductSpuTagMappingRepository productSpuTagMappingRepository;

    @Override
    public Page<ProductSpu> findByConditions(Pageable pageable, ProductSpuPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ProductSpuPaginationDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ProductSpu> pageResult = this.productSpuRepository.findByConditions((Page<ProductSpu>)page, dto);
        if (pageResult != null && CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            List<String> spuCodeList = pageResult.getRecords().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).map(ProductSpu::getSpuCode).collect(Collectors.toList());
            List<ProductSpuRelateSku> productSpuRelateSkuList = this.productSpuRelateSkuService.findBySpuCodes(spuCodeList);
            Map<Object, Object> map = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(productSpuRelateSkuList)) {
                map = productSpuRelateSkuList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).collect(Collectors.groupingBy(ProductSpuRelateSku::getSpuCode, Collectors.counting()));
            }
            for (ProductSpu item : pageResult.getRecords()) {
                item.setProductQuantity(map.getOrDefault(item.getSpuCode(), 0L));
            }
        }
        return pageResult;
    }

    @Override
    public List<ProductSpu> findDetailsByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Lists.newLinkedList();
        }
        List<ProductSpu> list = this.productSpuRepository.findByIds(idList);
        return this.findDetailsExtInfo(list);
    }

    @Override
    public List<ProductSpu> findDetailsBySpuCodes(List<String> spuCodeList) {
        if (CollectionUtils.isEmpty(spuCodeList)) {
            return Lists.newLinkedList();
        }
        List<ProductSpu> list = this.productSpuRepository.findBySpuCodes(spuCodeList);
        return this.findDetailsExtInfo(list);
    }

    @Override
    @Transactional
    public ProductSpu create(ProductSpu productSpu) {
        this.createValidation(productSpu);
        productSpu.setTenantCode(TenantUtils.getTenantCode());
        productSpu.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        productSpu.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isBlank((CharSequence)productSpu.getSpuCode())) {
            productSpu.setSpuCode((String)this.generateCodeService.generateCode("SPU", 1).get(0));
        } else {
            Integer count = this.productSpuRepository.countByRuleCode(productSpu.getSpuCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(productSpu.getSpuCode() + "\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        this.productSpuRepository.saveOrUpdate((Object)productSpu);
        this.bindExtInfo(productSpu);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return productSpu;
        }
        ProductSpuVo vo = (ProductSpuVo)this.nebulaToolkitService.copyObjectByBlankList((Object)productSpu, ProductSpuVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (ProductSpuEventListener eventListener : this.eventListeners) {
            eventListener.onCreate(vo);
        }
        return productSpu;
    }

    @Override
    @Transactional
    public ProductSpu update(ProductSpu productSpu) {
        this.updateValidation(productSpu);
        String currentId = productSpu.getId();
        List<ProductSpu> list = this.productSpuRepository.findByIds(Lists.newArrayList((Object[])new String[]{currentId}));
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(list), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ProductSpu current = list.get(0);
        Validate.isTrue((boolean)productSpu.getSpuCode().equals(current.getSpuCode()), (String)"\u5546\u54c1spu\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        this.productSpuRepository.saveOrUpdate((Object)productSpu);
        this.bindExtInfo(productSpu);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return productSpu;
        }
        ProductSpuVo oldVo = (ProductSpuVo)this.nebulaToolkitService.copyObjectByBlankList((Object)current, ProductSpuVo.class, HashSet.class, ArrayList.class, new String[0]);
        ProductSpuVo vo = (ProductSpuVo)this.nebulaToolkitService.copyObjectByBlankList((Object)productSpu, ProductSpuVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (ProductSpuEventListener eventListener : this.eventListeners) {
            eventListener.onUpdate(oldVo, vo);
        }
        return current;
    }

    @Transactional
    public void bindExtInfo(ProductSpu productSpu) {
        Validate.notNull((Object)((Object)productSpu), (String)"\u5546\u54c1spu\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        this.productSpuTagMappingService.saveBatch(productSpu.getTagList(), productSpu.getSpuCode());
        this.productSpuRelateSkuService.saveBatch(productSpu.getProductList(), productSpu.getSpuCode());
        this.productSpuIntroductionService.save(productSpu.getIntroduction(), productSpu.getSpuCode());
        ArrayList mediaList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(productSpu.getPictureList())) {
            productSpu.getPictureList().forEach(a -> {
                a.setSpuCode(productSpu.getSpuCode());
                a.setType(MediaTypeEnum.PICTURE.getCode());
            });
            mediaList.addAll(productSpu.getPictureList());
        }
        if (CollectionUtils.isNotEmpty(productSpu.getVideoList())) {
            productSpu.getVideoList().forEach(a -> {
                a.setSpuCode(productSpu.getSpuCode());
                a.setType(MediaTypeEnum.VIDEO.getCode());
            });
            mediaList.addAll(productSpu.getVideoList());
        }
        this.productSpuMediaService.saveBatch(mediaList, productSpu.getSpuCode());
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ProductSpu> list = this.productSpuRepository.findByIds(ids);
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, ProductSpu.class, ProductSpuVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.productSpuRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            this.eventListeners.forEach(productSpuEventListener -> productSpuEventListener.onEnable(voList));
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ProductSpu> list = this.productSpuRepository.findByIds(ids);
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, ProductSpu.class, ProductSpuVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.productSpuRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            this.eventListeners.forEach(productSpuEventListener -> productSpuEventListener.onDisable(voList));
        }
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ProductSpu> list = this.productSpuRepository.findByIds(ids);
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, ProductSpu.class, ProductSpuVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.productSpuRepository.updateDelFlagByIds(ids);
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            this.eventListeners.forEach(productSpuEventListener -> productSpuEventListener.onDelete(voList));
        }
    }

    @Override
    @Transactional
    public void upShelf(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productSpuRepository.updateIsShelfByIds(ids, IsShelfEnum.UP.getCode());
        List<ProductSpu> list = this.findDetailsByIds(ids);
        this.onUpOrDownShelf(list, IsShelfEnum.UP);
    }

    @Override
    @Transactional
    public void downShelf(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productSpuRepository.updateIsShelfByIds(ids, IsShelfEnum.DOWN.getCode());
        List<ProductSpu> list = this.findDetailsByIds(ids);
        this.onUpOrDownShelf(list, IsShelfEnum.DOWN);
    }

    @Override
    @Transactional
    public void upShelfBySpuCodes(List<String> spuCodeList) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(spuCodeList), (String)"\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productSpuRepository.updateIsShelfBySpuCodes(spuCodeList, IsShelfEnum.UP.getCode());
        List<ProductSpu> list = this.findDetailsBySpuCodes(spuCodeList);
        this.onUpOrDownShelf(list, IsShelfEnum.UP);
    }

    @Override
    @Transactional
    public void downShelfBySpuCodes(List<String> spuCodeList) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(spuCodeList), (String)"\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productSpuRepository.updateIsShelfBySpuCodes(spuCodeList, IsShelfEnum.DOWN.getCode());
        List<ProductSpu> list = this.findDetailsBySpuCodes(spuCodeList);
        this.onUpOrDownShelf(list, IsShelfEnum.DOWN);
    }

    @Override
    @Transactional
    public void updateUpShelfByProductCodes(Set<String> productCodeSet) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(productCodeSet), (String)"\u5546\u54c1\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ProductSpuRelateSku> list = this.productSpuRelateSkuService.findSupCodesByproductCodesAndIsShelf(productCodeSet, IsShelfEnum.DOWN.getCode());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<String> spuCodeList = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).map(ProductSpuRelateSku::getSpuCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(spuCodeList)) {
            return;
        }
        this.upShelfBySpuCodes(spuCodeList);
    }

    @Override
    @Transactional
    public void updateDownShelfByProductCodes(Set<String> productCodeSet) {
        List productVoList;
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(productCodeSet), (String)"\u5546\u54c1\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ProductSpuRelateSku> list = this.productSpuRelateSkuService.findSupCodesByproductCodesAndIsShelf(productCodeSet, IsShelfEnum.UP.getCode());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set allSpuCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).map(ProductSpuRelateSku::getSpuCode).collect(Collectors.toSet());
        Set skuCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode()) && !productCodeSet.contains(a.getProductCode())).map(ProductSpuRelateSku::getProductCode).collect(Collectors.toSet());
        Set<Object> upShelfProductCodeSet = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(skuCodeSet) && CollectionUtils.isNotEmpty((Collection)(productVoList = this.productVoService.findDetailsByIdsOrProductCodes(null, (List)Lists.newArrayList(skuCodeSet))))) {
            upShelfProductCodeSet = productVoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode()) && IsShelfEnum.UP.getCode().equals(a.getIsShelf())).map(ProductVo::getProductCode).collect(Collectors.toSet());
        }
        HashSet spuCodeList = Sets.newHashSet();
        for (ProductSpuRelateSku item : list) {
            if (!upShelfProductCodeSet.contains(item.getProductCode())) continue;
            spuCodeList.add(item.getSpuCode());
        }
        Sets.SetView setView = Sets.difference(allSpuCodeSet, (Set)spuCodeList);
        if (CollectionUtils.isEmpty((Collection)setView)) {
            return;
        }
        this.downShelfBySpuCodes(Lists.newArrayList((Iterable)setView));
    }

    private void createValidation(ProductSpu productSpu) {
        Validate.notNull((Object)((Object)productSpu), (String)"\u5546\u54c1spu\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        this.validation(productSpu);
    }

    private void updateValidation(ProductSpu productSpu) {
        Validate.notNull((Object)((Object)productSpu), (String)"\u5546\u54c1spu\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productSpu.getId(), (String)"\u5546\u54c1spu id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validation(productSpu);
    }

    private void validation(ProductSpu productSpu) {
        Validate.notBlank((CharSequence)productSpu.getSpuName(), (String)"\u5546\u54c1spu\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productSpu.getIsShelf(), (String)"\u5546\u54c1spu\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productSpu.getBeginDateTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productSpu.getEndDateTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((productSpu.getEndDateTime().compareTo(productSpu.getBeginDateTime()) > 0 ? 1 : 0) != 0, (String)"\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((productSpu.getEndDateTime().compareTo(new Date()) > 0 ? 1 : 0) != 0, (String)"\u622a\u6b62\u65f6\u95f4\u9700\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
    }

    private void onUpOrDownShelf(List<ProductSpu> list, IsShelfEnum shelfEnum) {
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return;
        }
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ProductSpu.class, ProductSpuVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (ProductSpuEventListener event : this.eventListeners) {
            if (shelfEnum.equals((Object)IsShelfEnum.UP)) {
                event.onUpShelf(voList);
                continue;
            }
            if (!shelfEnum.equals((Object)IsShelfEnum.DOWN)) continue;
            event.onDownShelf(voList);
        }
    }

    private List<ProductSpu> findDetailsExtInfo(List<ProductSpu> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        List<String> spuCodeList = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).map(ProductSpu::getSpuCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(spuCodeList)) {
            return Lists.newLinkedList();
        }
        ProductSpuTagMappingQueryDto queryDto = new ProductSpuTagMappingQueryDto();
        queryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        queryDto.setTenantCode(TenantUtils.getTenantCode());
        queryDto.setSpuCodes((Set)Sets.newHashSet(spuCodeList));
        List<ProductSpuTagMapping> tagList = this.productSpuTagMappingRepository.findByProductSpuTagMappingQueryDto(queryDto);
        List<ProductSpuRelateSku> skuList = this.productSpuRelateSkuService.findBySpuCodes(spuCodeList);
        List<ProductSpuMedia> mediaList = this.productSpuMediaService.findBySpuCodes(spuCodeList);
        List<ProductSpuIntroduction> introductionList = this.productSpuIntroductionService.findBySpuCodes(spuCodeList);
        Map<Object, Object> mapTag = Maps.newHashMap();
        Map<Object, Object> mapSku = Maps.newHashMap();
        Map<Object, Object> mapMedia = Maps.newHashMap();
        Map<Object, Object> mapIntro = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(tagList)) {
            mapTag = tagList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).collect(Collectors.groupingBy(ProductSpuTagMapping::getSpuCode));
        }
        if (CollectionUtils.isNotEmpty(skuList)) {
            mapSku = skuList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).collect(Collectors.groupingBy(ProductSpuRelateSku::getSpuCode));
        }
        if (CollectionUtils.isNotEmpty(mediaList)) {
            mapMedia = mediaList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).collect(Collectors.groupingBy(ProductSpuMedia::getSpuCode));
        }
        if (CollectionUtils.isNotEmpty(introductionList)) {
            mapIntro = introductionList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).collect(Collectors.groupingBy(ProductSpuIntroduction::getSpuCode));
        }
        for (ProductSpu item : list) {
            List introductionList1;
            List productSpuTagVos = (List)mapTag.get(item.getSpuCode());
            if (!CollectionUtils.isEmpty((Collection)productSpuTagVos)) {
                Collection productSpuTags = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)productSpuTagVos, ProductSpuTagMapping.class, ProductSpuTag.class, HashSet.class, ArrayList.class, new String[0]);
                item.setTagList(Lists.newArrayList((Iterable)productSpuTags));
            }
            item.setProductList((List)mapSku.get(item.getSpuCode()));
            List mediaList1 = (List)mapMedia.get(item.getSpuCode());
            if (CollectionUtils.isNotEmpty((Collection)mediaList1)) {
                Map<String, List<ProductSpuMedia>> curMap = mediaList1.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getType())).collect(Collectors.groupingBy(ProductSpuMedia::getType));
                item.setPictureList(curMap.get(MediaTypeEnum.PICTURE.getCode()));
                item.setVideoList(curMap.get(MediaTypeEnum.VIDEO.getCode()));
            }
            if (!CollectionUtils.isNotEmpty((Collection)(introductionList1 = (List)mapIntro.get(item.getSpuCode())))) continue;
            item.setIntroduction((ProductSpuIntroduction)((Object)introductionList1.get(0)));
        }
        return list;
    }
}

