/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuRelateSku;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTag;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTagMapping;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuTagMappingRepository;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuRelateSkuService;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuTagMappingService;
import com.biz.crm.mdm.business.product.spu.sdk.dto.BindTagDto;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagMappingPaginationDto;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagMappingQueryDto;
import com.biz.crm.mdm.business.product.spu.sdk.dto.RebindTagDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductSpuTagMappingServiceImpl
implements ProductSpuTagMappingService {
    @Autowired
    private ProductSpuTagMappingRepository productSpuTagMappingRepository;
    @Autowired
    private ProductSpuRelateSkuService productSpuRelateSkuService;

    @Override
    public Page<ProductSpuTagMapping> findByConditions(Pageable pageable, ProductSpuTagMappingPaginationDto paginationDto) {
        paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductSpuTagMappingPaginationDto());
        paginationDto.setTenantCode(TenantUtils.getTenantCode());
        paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.isBlank((CharSequence)paginationDto.getTagCode())) {
            return new Page();
        }
        Page<ProductSpuTagMapping> pageResult = this.productSpuTagMappingRepository.findByConditions((Page<ProductSpuTagMapping>)page, paginationDto);
        if (Objects.isNull(pageResult) || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return pageResult;
        }
        Map<String, String> map = this.findSpuRelateTagNameMap(pageResult.getRecords());
        Map<String, Long> map1 = this.findSpuRelateSkuNum(pageResult.getRecords());
        for (ProductSpuTagMapping item : pageResult.getRecords()) {
            item.setTagName(map.getOrDefault(item.getSpuCode(), ""));
            item.setProductQuantity(map1.getOrDefault(item.getSpuCode(), 0L));
        }
        return pageResult;
    }

    @Override
    public Page<ProductSpuTagMapping> findExcludeByConditions(Pageable pageable, ProductSpuTagMappingPaginationDto paginationDto) {
        paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductSpuTagMappingPaginationDto());
        paginationDto.setTenantCode(TenantUtils.getTenantCode());
        paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.isBlank((CharSequence)paginationDto.getTagCode())) {
            return new Page();
        }
        Page<ProductSpuTagMapping> pageResult = this.productSpuTagMappingRepository.findExcludeByConditions((Page<ProductSpuTagMapping>)page, paginationDto);
        if (Objects.isNull(pageResult) || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return pageResult;
        }
        Map<String, String> map = this.findSpuRelateTagNameMap(pageResult.getRecords());
        Map<String, Long> map1 = this.findSpuRelateSkuNum(pageResult.getRecords());
        for (ProductSpuTagMapping item : pageResult.getRecords()) {
            item.setTagName(map.getOrDefault(item.getSpuCode(), ""));
            item.setProductQuantity(map1.getOrDefault(item.getSpuCode(), 0L));
        }
        return pageResult;
    }

    @Override
    @Transactional
    public void saveBatch(List<ProductSpuTag> tagList, String spuCode) {
        Validate.notBlank((CharSequence)spuCode, (String)"spuCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productSpuTagMappingRepository.deleteBySupCodes(Sets.newHashSet((Object[])new String[]{spuCode}));
        if (CollectionUtils.isEmpty(tagList)) {
            return;
        }
        ArrayList<ProductSpuTagMapping> mappings = new ArrayList<ProductSpuTagMapping>();
        for (ProductSpuTag tag : tagList) {
            ProductSpuTagMapping mapping = new ProductSpuTagMapping();
            mapping.setTagCode(tag.getTagCode());
            mapping.setSpuCode(spuCode);
            mapping.setTenantCode(TenantUtils.getTenantCode());
            mapping.setItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{mapping.getTenantCode(), mapping.getTagCode(), mapping.getSpuCode()}));
            mappings.add(mapping);
        }
        this.deleteMapping(mappings);
        this.productSpuTagMappingRepository.saveBatch(mappings);
    }

    @Override
    @Transactional
    public void bindTag(BindTagDto dto) {
        boolean f = Objects.nonNull(dto) && StringUtils.isNotBlank((CharSequence)dto.getTagCode()) && CollectionUtils.isNotEmpty((Collection)dto.getSpuCodeSet());
        Validate.isTrue((boolean)f, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productSpuTagMappingRepository.deleteByTagCodeAndSupCodes(dto.getTagCode(), dto.getSpuCodeSet());
        LinkedList list = Lists.newLinkedList();
        for (String item : dto.getSpuCodeSet()) {
            ProductSpuTagMapping mapping = new ProductSpuTagMapping();
            mapping.setTagCode(dto.getTagCode());
            mapping.setSpuCode(item);
            mapping.setTenantCode(TenantUtils.getTenantCode());
            mapping.setItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{mapping.getTenantCode(), mapping.getTagCode(), mapping.getSpuCode()}));
            list.add(mapping);
        }
        this.deleteMapping(list);
        this.productSpuTagMappingRepository.saveBatch(list);
    }

    @Override
    @Transactional
    public void rebindTag(RebindTagDto dto) {
        boolean f = Objects.nonNull(dto) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getOldTagCode(), dto.getTagCode()}) && CollectionUtils.isNotEmpty((Collection)dto.getSpuCodeSet());
        Validate.isTrue((boolean)f, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productSpuTagMappingRepository.deleteByTagCodeAndSupCodes(dto.getOldTagCode(), dto.getSpuCodeSet());
        LinkedList list = Lists.newLinkedList();
        for (String item : dto.getSpuCodeSet()) {
            ProductSpuTagMapping mapping = new ProductSpuTagMapping();
            mapping.setTagCode(dto.getTagCode());
            mapping.setSpuCode(item);
            mapping.setTenantCode(TenantUtils.getTenantCode());
            mapping.setItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{mapping.getTenantCode(), mapping.getTagCode(), mapping.getSpuCode()}));
            list.add(mapping);
        }
        this.deleteMapping(list);
        this.productSpuTagMappingRepository.saveBatch(list);
    }

    @Override
    @Transactional
    public void unbindTag(BindTagDto dto) {
        boolean f = Objects.nonNull(dto) && StringUtils.isNotBlank((CharSequence)dto.getTagCode()) && CollectionUtils.isNotEmpty((Collection)dto.getSpuCodeSet());
        Validate.isTrue((boolean)f, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productSpuTagMappingRepository.deleteByTagCodeAndSupCodes(dto.getTagCode(), dto.getSpuCodeSet());
    }

    private void deleteMapping(List<ProductSpuTagMapping> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set<String> itemKeys = list.stream().map(ProductSpuTagMapping::getItemKey).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(itemKeys)) {
            return;
        }
        this.productSpuTagMappingRepository.deleteByItemKeys(itemKeys);
    }

    private Map<String, String> findSpuRelateTagNameMap(List<ProductSpuTagMapping> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Set spuCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).map(ProductSpuTagMapping::getSpuCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(spuCodeSet)) {
            return Maps.newHashMap();
        }
        ProductSpuTagMappingQueryDto queryDto = new ProductSpuTagMappingQueryDto();
        queryDto.setTenantCode(TenantUtils.getTenantCode());
        queryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        queryDto.setSpuCodes(spuCodeSet);
        List<ProductSpuTagMapping> tagMappingList = this.productSpuTagMappingRepository.findByProductSpuTagMappingQueryDto(queryDto);
        if (CollectionUtils.isEmpty(tagMappingList)) {
            return Maps.newHashMap();
        }
        return tagMappingList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getSpuCode(), a.getTagName()})).collect(Collectors.groupingBy(ProductSpuTagMapping::getSpuCode, Collectors.mapping(ProductSpuTagMapping::getTagName, Collectors.joining(","))));
    }

    private Map<String, Long> findSpuRelateSkuNum(List<ProductSpuTagMapping> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Set spuCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).map(ProductSpuTagMapping::getSpuCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(spuCodeSet)) {
            return Maps.newHashMap();
        }
        List<ProductSpuRelateSku> productSpuRelateSkuList = this.productSpuRelateSkuService.findBySpuCodes(Lists.newArrayList(spuCodeSet));
        if (CollectionUtils.isEmpty(productSpuRelateSkuList)) {
            return Maps.newHashMap();
        }
        return productSpuRelateSkuList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpuCode())).collect(Collectors.groupingBy(ProductSpuRelateSku::getSpuCode, Collectors.counting()));
    }
}

