package com.biz.crm.mdm.business.product.spu.local.service;

import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuRelateSku;
import java.util.List;
import java.util.Set;

/**
 * 商品spu关联的sku信息(ProductSpuRelateSku)表服务接口
 *
 * @author sunx
 * @date 2021-12-02 16:08:19
 */
public interface ProductSpuRelateSkuService {

  /**
   * 批量保存关联的sku信息
   *
   * @param productList
   * @param spuCode
   */
  void saveBatch(List<ProductSpuRelateSku> productList, String spuCode);

  /**
   * 根据spuCode集合获取关联的sku信息
   *
   * @param spuCodeList
   * @return
   */
  List<ProductSpuRelateSku> findBySpuCodes(List<String> spuCodeList);

  /**
   * 获取sku商品关联的对应的上下架状态的spu-sku关联集合
   *
   * @param productCodeSet
   * @param isShelf
   * @return
   */
  List<ProductSpuRelateSku> findSupCodesByproductCodesAndIsShelf(
      Set<String> productCodeSet, String isShelf);
}
