package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuMedia;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuMediaRepository;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuMediaService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 商品spu图片视频信息(ProductSpuMedia)表服务实现类
 *
 * @author sunx
 * @date 2021-12-02 16:07:51
 */
@Slf4j
@Service("productSpuMediaService")
public class ProductSpuMediaServiceImpl implements ProductSpuMediaService {

  @Autowired(required = false) private ProductSpuMediaRepository productSpuMediaRepository;

  @Override
  @Transactional
  public void saveBatch(List<ProductSpuMedia> mediaList, String spuCode) {
    Validate.notBlank(spuCode, "spuCode不能为空");
    this.productSpuMediaRepository.deleteBySpuCodes(Lists.newArrayList(spuCode));
    if (CollectionUtils.isEmpty(mediaList)) {
      return;
    }
    int sort = 1;
    for (ProductSpuMedia a : mediaList) {
      a.setSpuCode(spuCode);
      a.setTenantCode(TenantUtils.getTenantCode());
      a.setSort(++sort);
    }
    this.productSpuMediaRepository.saveBatch(mediaList);
  }

  @Override
  public List<ProductSpuMedia> findBySpuCodes(List<String> spuCodeList) {
    if (CollectionUtils.isEmpty(spuCodeList)) {
      return Lists.newLinkedList();
    }
    return this.productSpuMediaRepository.findBySpuCodesAndType(spuCodeList, StringUtils.EMPTY);
  }
}
