/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuMedia;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuMediaRepository;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuMediaService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productSpuMediaService")
public class ProductSpuMediaServiceImpl
implements ProductSpuMediaService {
    private static final Logger log = LoggerFactory.getLogger(ProductSpuMediaServiceImpl.class);
    @Autowired(required=false)
    private ProductSpuMediaRepository productSpuMediaRepository;

    @Override
    @Transactional
    public void saveBatch(List<ProductSpuMedia> mediaList, String spuCode) {
        Validate.notBlank((CharSequence)spuCode, (String)"spuCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productSpuMediaRepository.deleteBySpuCodes(Lists.newArrayList((Object[])new String[]{spuCode}));
        if (CollectionUtils.isEmpty(mediaList)) {
            return;
        }
        int sort = 1;
        for (ProductSpuMedia a : mediaList) {
            a.setSpuCode(spuCode);
            a.setTenantCode(TenantUtils.getTenantCode());
            a.setSort(++sort);
        }
        this.productSpuMediaRepository.saveBatch(mediaList);
    }

    @Override
    public List<ProductSpuMedia> findBySpuCodes(List<String> spuCodeList) {
        if (CollectionUtils.isEmpty(spuCodeList)) {
            return Lists.newLinkedList();
        }
        return this.productSpuMediaRepository.findBySpuCodesAndType(spuCodeList, "");
    }
}

