/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuRelateSku;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuRelateSkuRepository;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuRelateSkuService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productSpuRelateSkuService")
public class ProductSpuRelateSkuServiceImpl
implements ProductSpuRelateSkuService {
    private static final Logger log = LoggerFactory.getLogger(ProductSpuRelateSkuServiceImpl.class);
    @Autowired(required=false)
    private ProductSpuRelateSkuRepository productSpuRelateSkuRepository;
    @Autowired(required=false)
    private ProductVoService productVoService;

    @Override
    @Transactional
    public void saveBatch(List<ProductSpuRelateSku> productList, String spuCode) {
        Validate.notBlank((CharSequence)spuCode, (String)"spuCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productSpuRelateSkuRepository.deleteBySpuCodes(Lists.newArrayList((Object[])new String[]{spuCode}));
        if (CollectionUtils.isEmpty(productList)) {
            return;
        }
        int sort = 1;
        for (ProductSpuRelateSku a : productList) {
            a.setSpuCode(spuCode);
            a.setTenantCode(TenantUtils.getTenantCode());
            a.setSort(++sort);
        }
        this.productSpuRelateSkuRepository.saveBatch(productList);
    }

    @Override
    public List<ProductSpuRelateSku> findBySpuCodes(List<String> spuCodeList) {
        if (CollectionUtils.isEmpty(spuCodeList)) {
            return Lists.newLinkedList();
        }
        List<ProductSpuRelateSku> list = this.productSpuRelateSkuRepository.findBySpuCodes(spuCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        List skuCodeList = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode())).map(ProductSpuRelateSku::getProductCode).collect(Collectors.toList());
        List skuList = this.productVoService.findDetailsByIdsOrProductCodes(null, skuCodeList);
        if (CollectionUtils.isEmpty((Collection)skuList)) {
            return list;
        }
        Map mapSku = skuList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode())).collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (a, b) -> a));
        list.forEach(a -> {
            ProductVo productVo = (ProductVo)mapSku.get(a.getProductCode());
            if (Objects.nonNull(productVo)) {
                a.setIsShelf(productVo.getIsShelf());
                a.setProductLevelName(productVo.getProductLevelName());
                a.setProductName(productVo.getProductName());
                a.setProductType(productVo.getProductType());
                a.setSpec(productVo.getSpec());
            }
        });
        return list;
    }

    @Override
    public List<ProductSpuRelateSku> findSupCodesByproductCodesAndIsShelf(Set<String> productCodeSet, String isShelf) {
        if (CollectionUtils.isEmpty(productCodeSet) || StringUtils.isBlank((CharSequence)isShelf)) {
            return Lists.newLinkedList();
        }
        return this.productSpuRelateSkuRepository.findSupCodesByproductCodesAndIsShelf(productCodeSet, isShelf);
    }
}

