package com.biz.crm.mdm.business.product.spu.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuRelateSkuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.FavoriteProductVO;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商品spu关联sku
 *
 * @author sunx
 * @date 2021/12/3
 */
@Slf4j
@Api(tags = "商品spu关联sku: ProductSpuRelateSkuVo: 商品spu关联sku")
@RestController
@RequestMapping(value = {"/v1/productSpu/productSpuRelateSku"})
public class ProductSpuRelateSkuVoController {

  @Autowired(required = false) private ProductSpuRelateSkuVoService productSpuRelateSkuVoService;

  /**
   * 根据spuCode集合获取关联sku信息
   *
   * @param spuCodeList
   * @return
   */
  @ApiOperation(value = "根据spuCode集合获取关联sku信息")
  @GetMapping(value = {"/findBySpuCodes"})
  public Result<List<ProductSpuRelateSkuVo>> findBySpuCodes(
      @RequestParam("spuCodeList") List<String> spuCodeList) {
    try {
      List<ProductSpuRelateSkuVo> list =
          this.productSpuRelateSkuVoService.findBySpuCodes(spuCodeList);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据spuCode集合获取关联sku信息
   *
   * @param productCodeList
   * @return
   */
  @ApiOperation(value = "根据spuCode集合获取关联sku信息")
  @GetMapping(value = {"/findByProductCodes"})
  public Result<List<ProductSpuRelateSkuVo>> findByProductCodes(
      @RequestParam("productCodeList") List<String> productCodeList) {
    try {
      List<ProductSpuRelateSkuVo> list =
          this.productSpuRelateSkuVoService.findByProductCodes(productCodeList);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }



}
