package com.biz.crm.mdm.business.product.spu.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTag;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuTagService;
import com.biz.crm.mdm.business.product.spu.sdk.dto.BindTagDto;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagPaginationDto;
import com.biz.crm.mdm.business.product.spu.sdk.dto.RebindTagDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/** 商品spu标签管理 @Author: zengxingwang @Date: 2021/12/22 14:12 */
@Slf4j
@Api(tags = "商品spu标签管理")
@RestController
@RequestMapping(value = {"/v1/productSpu/productSpuTag"})
public class ProductSpuTagController {

  @Autowired(required = false)
  private ProductSpuTagService productSpuTagService;

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询(可适用于列表分页查询和公用分页弹框)", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<ProductSpuTag>> findByConditions(
      @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "paginationDto", value = "分页Dto") ProductSpuTagPaginationDto paginationDto) {
    try {
      Page<ProductSpuTag> result =
          this.productSpuTagService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param productSpuTag
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<ProductSpuTag> create(@RequestBody ProductSpuTag productSpuTag) {
    try {
      ProductSpuTag current = this.productSpuTagService.create(productSpuTag);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改
   *
   * @param productSpuTag
   * @return
   */
  @ApiOperation(value = "修改")
  @PatchMapping(value = "")
  public Result<ProductSpuTag> update(@RequestBody ProductSpuTag productSpuTag) {
    try {
      ProductSpuTag current = this.productSpuTagService.update(productSpuTag);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "批量删除")
  @DeleteMapping("/deleteBatch")
  public Result<?> deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.productSpuTagService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "批量启用")
  @PatchMapping("/enableBatch")
  public Result<?> enableBatch(@RequestBody List<String> ids) {
    try {
      this.productSpuTagService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "批量禁用")
  @PatchMapping("/disableBatch")
  public Result<?> disableBatch(@RequestBody List<String> ids) {
    try {
      this.productSpuTagService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查看详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "查看详情")
  @GetMapping(value = "findById")
  public Result<ProductSpuTag> findById(@RequestParam(value = "id", required = false) String id) {
    try {
      ProductSpuTag current = this.productSpuTagService.findById(id);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
