package com.biz.crm.mdm.business.product.spu.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品spu介绍详情(ProductSpuIntroduction)实体类
 *
 * @author sunx
 * @since 2021-12-02 16:07:21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_product_spu_introduction")
@Table(
    name = "mdm_product_spu_introduction",
    indexes = {
      @Index(name = "mdm_product_spu_introduction1", columnList = "tenant_code"),
      @Index(name = "mdm_product_spu_introduction2", columnList = "spu_code"),
    })
@ApiModel(value = "ProductSpuIntroduction", description = "商品spu介绍详情")
@org.hibernate.annotations.Table(appliesTo = "mdm_product_spu_introduction", comment = "商品spu介绍详情")
public class ProductSpuIntroduction extends TenantEntity {

  /** 商品spu编码 */
  @ApiModelProperty("商品spu编码")
  @TableField(value = "spu_code")
  @Column(name = "spu_code", length = 32, columnDefinition = "varchar(32) COMMENT '商品spu编码'")
  private String spuCode;

  /** 介绍详情 */
  @ApiModelProperty("介绍详情")
  @TableField(value = "introduction_text")
  @Column(name = "introduction_text", length = -1, columnDefinition = "blob COMMENT '介绍详情'")
  private String introductionText;
}
