package com.biz.crm.mdm.business.product.spu.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTagMapping;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagMappingPaginationDto;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagMappingQueryDto;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 商品spu标签管理关联关系mapper
 *
 * @author sunx
 * @date 2021-12-02 16:04:58
 */
public interface ProductSpuTagMappingMapper extends BaseMapper<ProductSpuTagMapping> {

  /**
   * 多条件分页查询
   *
   * @param page
   * @param dto
   * @return
   */
  Page<ProductSpuTagMapping> findByConditions(
      Page<ProductSpuTagMapping> page, @Param("dto") ProductSpuTagMappingPaginationDto dto);

  /**
   * 分页(未关联当前标签的spu分页)
   *
   * @param page
   * @param dto
   * @return
   */
  Page<ProductSpuTagMapping> findExcludeByConditions(
      Page<ProductSpuTagMapping> page, @Param("dto") ProductSpuTagMappingPaginationDto dto);

  /**
   * 根据ProductSpuTagMappingQueryDto获取关联的标签信息
   *
   * @param dto
   * @return
   */
  List<ProductSpuTagMapping> findByProductSpuTagMappingQueryDto(
      @Param("dto") ProductSpuTagMappingQueryDto dto);
}
