package com.biz.crm.mdm.business.product.spu.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTagMapping;
import com.biz.crm.mdm.business.product.spu.local.mapper.ProductSpuTagMappingMapper;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagMappingPaginationDto;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagMappingQueryDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

/** 商品spu标签管理关联关系持久化 @Author: zengxingwang @Date: 2021/12/22 15:08 */
@Component
public class ProductSpuTagMappingRepository
    extends ServiceImpl<ProductSpuTagMappingMapper, ProductSpuTagMapping> {

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<ProductSpuTagMapping> findByConditions(
      Page<ProductSpuTagMapping> page, ProductSpuTagMappingPaginationDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 分页(未关联当前标签的spu分页)
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<ProductSpuTagMapping> findExcludeByConditions(
      Page<ProductSpuTagMapping> page, ProductSpuTagMappingPaginationDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.baseMapper.findExcludeByConditions(page, dto);
  }

  /**
   * 通过标签编码删除
   *
   * @param tagCodes
   */
  public void deleteByTagCodes(Set<String> tagCodes) {
    LambdaQueryWrapper<ProductSpuTagMapping> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.in(ProductSpuTagMapping::getTagCode, tagCodes);
    lambdaQuery.eq(ProductSpuTagMapping::getTenantCode, TenantUtils.getTenantCode());
    this.baseMapper.delete(lambdaQuery);
  }

  /**
   * 通过spu商品编码删除
   *
   * @param spuCodes
   */
  public void deleteBySupCodes(Set<String> spuCodes) {
    LambdaQueryWrapper<ProductSpuTagMapping> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ProductSpuTagMapping::getTenantCode, TenantUtils.getTenantCode());
    lambdaQuery.in(ProductSpuTagMapping::getSpuCode, spuCodes);
    this.baseMapper.delete(lambdaQuery);
  }

  /**
   * 通过ProductSpuTagMappingQueryDto查询关联标签spu信息
   *
   * @param dto
   * @return
   */
  public List<ProductSpuTagMapping> findByProductSpuTagMappingQueryDto(
      ProductSpuTagMappingQueryDto dto) {
    return this.baseMapper.findByProductSpuTagMappingQueryDto(dto);
  }

  /**
   * 根据标签编码+spu编码集合删除关联数据
   *
   * @param tagCode
   * @param spuCodeSet
   */
  public void deleteByTagCodeAndSupCodes(String tagCode, Set<String> spuCodeSet) {
    LambdaQueryWrapper<ProductSpuTagMapping> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ProductSpuTagMapping::getTenantCode, TenantUtils.getTenantCode());
    lambdaQuery.eq(ProductSpuTagMapping::getTagCode, tagCode);
    lambdaQuery.in(ProductSpuTagMapping::getSpuCode, spuCodeSet);
    this.baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据itemKeys删除关联数据
   *
   * @param itemKeys
   */
  public void deleteByItemKeys(Set<String> itemKeys) {
    LambdaQueryWrapper<ProductSpuTagMapping> lambdaQuery = Wrappers.lambdaQuery();
    for (List<String> item : Lists.partition(Lists.newArrayList(itemKeys), 500)) {
      lambdaQuery.in(ProductSpuTagMapping::getItemKey, item);
      //新增租户编号
      lambdaQuery.eq(ProductSpuTagMapping::getTenantCode,TenantUtils.getTenantCode());
      this.baseMapper.delete(lambdaQuery);
    }
  }
}
