package com.biz.crm.mdm.business.product.spu.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTag;
import com.biz.crm.mdm.business.product.spu.local.mapper.ProductSpuTagMapper;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagPaginationDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 商品spu标签信息(repository)
 *
 * @author sunx
 * @date 2021-12-02 17:07:24
 */
@Component
public class ProductSpuTagRepository extends ServiceImpl<ProductSpuTagMapper, ProductSpuTag> {

  /**
   * 多条件分页查询
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  public Page<ProductSpuTag> findByConditions(
      Pageable pageable, ProductSpuTagPaginationDto paginationDto) {
    Page<ProductSpuTag> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, paginationDto);
  }

  /**
   * 根据标签名称查询
   *
   * @param tagName
   * @return
   */
  public ProductSpuTag findByTagName(String tagName) {
    LambdaQueryWrapper<ProductSpuTag> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ProductSpuTag::getTagName, tagName);
    //新增租户编号
    lambdaQuery.eq(ProductSpuTag::getTenantCode,TenantUtils.getTenantCode());
    return this.baseMapper.selectOne(lambdaQuery);
  }

  /** 批量删除 */
  public void deleteBatch(List<String> ids) {
    LambdaQueryWrapper<ProductSpuTag> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ProductSpuTag::getTenantCode, TenantUtils.getTenantCode());
    lambdaQuery.in(ProductSpuTag::getId, ids);
    this.baseMapper.delete(lambdaQuery);
  }

  /**
   * 修改启禁用
   *
   * @param ids
   * @param code
   */
  public void updateEnableStatusByIds(List<String> ids, String code) {
    this.lambdaUpdate()
        .in(ProductSpuTag::getId, ids)
        .eq(ProductSpuTag::getTenantCode,TenantUtils.getTenantCode())
        .set(ProductSpuTag::getEnableStatus, code)
        .update();
  }

  /**
   * 查看详情
   *
   * @param ids
   * @return
   */
  public List<ProductSpuTag> findByIds(List<String> ids) {
    return this.lambdaQuery()
        .in(ProductSpuTag::getId, ids)
        .eq(ProductSpuTag::getTenantCode,TenantUtils.getTenantCode())
        .list();
  }

  /**
   * 根据编码获取详情
   *
   * @param tagCode
   * @return
   */
  public ProductSpuTag findByTagCode(String tagCode) {
    return this.lambdaQuery()
        .eq(ProductSpuTag::getTagCode, tagCode)
        .eq(ProductSpuTag::getTenantCode, TenantUtils.getTenantCode())
        .one();
  }

  /**
   * 重构修改方法
   * @param productSpuTag
   * @param tenantCode
   */
  public void updateByIdAndTenantCode(ProductSpuTag productSpuTag, String tenantCode) {
    LambdaUpdateWrapper<ProductSpuTag> lambdaUpdateWrapper=Wrappers.lambdaUpdate();
    lambdaUpdateWrapper.eq(ProductSpuTag::getTenantCode,tenantCode);
    lambdaUpdateWrapper.in(ProductSpuTag::getId,productSpuTag.getId());
    this.baseMapper.update(productSpuTag,lambdaUpdateWrapper);
  }
}
