package com.biz.crm.mdm.business.product.spu.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTag;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 商品spu标签信息(ProductSpuTag)表服务接口
 *
 * @author sunx
 * @date 2021-12-02 17:07:24
 */
public interface ProductSpuTagService {

  /**
   * 多条件分页查询
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<ProductSpuTag> findByConditions(Pageable pageable, ProductSpuTagPaginationDto paginationDto);

  /**
   * 创建
   *
   * @param productSpuTag
   * @return
   */
  ProductSpuTag create(ProductSpuTag productSpuTag);

  /**
   * 修改
   *
   * @param productSpuTag
   * @return
   */
  ProductSpuTag update(ProductSpuTag productSpuTag);

  /**
   * 批量启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 批量删除
   *
   * @param ids
   */
  void deleteBatch(List<String> ids);

  /**
   * 查看详情
   *
   * @param id
   * @return
   */
  ProductSpuTag findById(String id);
}
