package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpu;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuRepository;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuService;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuRelateSkuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
 * 商品spu信息Vo接口实现
 *
 * @author sunx
 * @date 2021/12/2
 */
@Service
public class ProductSpuVoServiceImpl implements ProductSpuVoService {

  @Autowired(required = false) private ProductSpuRepository productSpuRepository;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false) private ProductSpuService productSpuService;

  @Autowired(required = false) private ProductSpuRelateSkuVoService productSpuRelateSkuVoService;

  @Override
  public List<ProductSpuVo> findBySpuCodes(List<String> spuCodeList) {
    if (CollectionUtils.isEmpty(spuCodeList)) {
      return Lists.newLinkedList();
    }
    List<ProductSpu> list = this.productSpuRepository.findBySpuCodes(spuCodeList);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newLinkedList();
    }

    return (List<ProductSpuVo>)
        this.nebulaToolkitService.copyCollectionByBlankList(
            list, ProductSpu.class, ProductSpuVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public List<ProductSpuVo> findDetailsBySpuCodes(List<String> spuCodeList) {
    if (CollectionUtils.isEmpty(spuCodeList)) {
      return Lists.newLinkedList();
    }
    List<ProductSpu> list = this.productSpuService.findDetailsBySpuCodes(spuCodeList);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newLinkedList();
    }

    return (List<ProductSpuVo>)
        this.nebulaToolkitService.copyCollectionByBlankList(
            list, ProductSpu.class, ProductSpuVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public Map<String, List<ProductSpuVo>> findRelateSpuMapByProductCodes(
      List<String> productCodeList) {
    if (CollectionUtils.isEmpty(productCodeList)) {
      return Maps.newHashMap();
    }
    List<ProductSpuRelateSkuVo> list =
        this.productSpuRelateSkuVoService.findByProductCodes(productCodeList);
    Set<String> spuCodeSet =
        list.stream()
            .filter(a -> StringUtils.isNotBlank(a.getSpuCode()))
            .map(ProductSpuRelateSkuVo::getSpuCode)
            .collect(Collectors.toSet());
    // k-productCode,v-spuCodeList
    Map<String, List<String>> map =
        list.stream()
            .filter(a -> StringUtils.isNoneBlank(a.getSpuCode(), a.getProductCode()))
            .collect(
                Collectors.groupingBy(
                    ProductSpuRelateSkuVo::getProductCode,
                    Collectors.mapping(ProductSpuRelateSkuVo::getSpuCode, Collectors.toList())));
    if(CollectionUtils.isEmpty(spuCodeSet)){
      return Maps.newHashMap();
    }
    List<ProductSpu> spuList =
        this.productSpuRepository.findBySpuCodes(Lists.newArrayList(spuCodeSet));
    List<ProductSpuVo> spuVoList =
        (List<ProductSpuVo>)
            this.nebulaToolkitService.copyCollectionByBlankList(
                spuList, ProductSpu.class, ProductSpuVo.class, HashSet.class, ArrayList.class);
    Map<String, ProductSpuVo> mapSpuVo =
        spuVoList.stream()
            .filter(a -> StringUtils.isNotBlank(a.getSpuCode()))
            .collect(Collectors.toMap(ProductSpuVo::getSpuCode, Function.identity(), (a, b) -> a));
    Map<String, List<ProductSpuVo>> re = Maps.newHashMap();
    for (Entry<String, List<String>> item : map.entrySet()) {
      List<ProductSpuVo> curList = Lists.newLinkedList();
      for (String spuCode : item.getValue()) {
        if (mapSpuVo.keySet().contains(spuCode)) {
          curList.add(mapSpuVo.get(spuCode));
        }
      }
      if (CollectionUtils.isNotEmpty(curList)) {
        re.put(item.getKey(), curList);
      }
    }
    return re;
  }
}
