/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.event;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.product.spu.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.spu.sdk.event.ProductSpuEventListener;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductSpuEventLogListener
implements ProductSpuEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onCreate(ProductSpuVo vo) {
        String onlyKey = vo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(null);
        crmBusinessLogDto.setNewObject((Object)vo);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onUpdate(ProductSpuVo oldVo, ProductSpuVo newVo) {
        String onlyKey = newVo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)oldVo);
        crmBusinessLogDto.setNewObject((Object)newVo);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onEnable(List<ProductSpuVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(productSpuVo -> {
            String onlyKey = productSpuVo.getId();
            ProductSpuVo oldObj = new ProductSpuVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(productSpuVo.getEnableStatus());
            ProductSpuVo newObj = new ProductSpuVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject((Object)oldObj);
            crmBusinessLogDto.setNewObject((Object)newObj);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onDisable(List<ProductSpuVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(productSpuVo -> {
            String onlyKey = productSpuVo.getId();
            ProductSpuVo oldObj = new ProductSpuVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(productSpuVo.getEnableStatus());
            ProductSpuVo newObj = new ProductSpuVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject((Object)oldObj);
            crmBusinessLogDto.setNewObject((Object)newObj);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onDelete(List<ProductSpuVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(productSpuVo -> {
            String onlyKey = productSpuVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(productSpuVo);
            crmBusinessLogDto.setNewObject(null);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onUpShelf(List<ProductSpuVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        voList.forEach(productSpuVo -> {
            String onlyKey = productSpuVo.getId();
            ProductSpuVo oldObj = new ProductSpuVo();
            oldObj.setId(onlyKey);
            oldObj.setIsShelf(IsShelfEnum.DOWN.getCode());
            ProductSpuVo newObj = new ProductSpuVo();
            newObj.setId(onlyKey);
            newObj.setIsShelf(productSpuVo.getIsShelf());
            this.onUpdate(oldObj, newObj);
        });
    }

    public void onDownShelf(List<ProductSpuVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        voList.forEach(productSpuVo -> {
            String onlyKey = productSpuVo.getId();
            ProductSpuVo oldObj = new ProductSpuVo();
            oldObj.setId(onlyKey);
            oldObj.setIsShelf(IsShelfEnum.UP.getCode());
            ProductSpuVo newObj = new ProductSpuVo();
            newObj.setId(onlyKey);
            newObj.setIsShelf(productSpuVo.getIsShelf());
            this.onUpdate(oldObj, newObj);
        });
    }
}

