/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTag;
import com.biz.crm.mdm.business.product.spu.local.mapper.ProductSpuTagMapper;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagPaginationDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ProductSpuTagRepository
extends ServiceImpl<ProductSpuTagMapper, ProductSpuTag> {
    public Page<ProductSpuTag> findByConditions(Pageable pageable, ProductSpuTagPaginationDto paginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((ProductSpuTagMapper)this.baseMapper).findByConditions((Page<ProductSpuTag>)page, paginationDto);
    }

    public ProductSpuTag findByTagName(String tagName) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(ProductSpuTag::getTagName, (Object)tagName);
        lambdaQuery.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        return (ProductSpuTag)((Object)((ProductSpuTagMapper)this.baseMapper).selectOne((Wrapper)lambdaQuery));
    }

    public void deleteBatch(List<String> ids) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        lambdaQuery.in(UuidEntity::getId, ids);
        ((ProductSpuTagMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
    }

    public void updateEnableStatusByIds(List<String> ids, String code) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getEnableStatus, (Object)code)).update();
    }

    public List<ProductSpuTag> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public ProductSpuTag findByTagCode(String tagCode) {
        return (ProductSpuTag)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProductSpuTag::getTagCode, (Object)tagCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public void updateByIdAndTenantCode(ProductSpuTag productSpuTag, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{productSpuTag.getId()});
        ((ProductSpuTagMapper)this.baseMapper).update((Object)productSpuTag, (Wrapper)lambdaUpdateWrapper);
    }
}

