/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTag;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTagMapping;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuTagMappingRepository;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuTagRepository;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuTagService;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagMappingQueryDto;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagPaginationDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productSpuTagService")
public class ProductSpuTagServiceImpl
implements ProductSpuTagService {
    private static final Logger log = LoggerFactory.getLogger(ProductSpuTagServiceImpl.class);
    @Autowired(required=false)
    private ProductSpuTagRepository productSpuTagRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ProductSpuTagMappingRepository productSpuTagMappingRepository;

    @Override
    public Page<ProductSpuTag> findByConditions(Pageable pageable, ProductSpuTagPaginationDto paginationDto) {
        paginationDto = (ProductSpuTagPaginationDto)ObjectUtils.defaultIfNull((Object)paginationDto, (Object)new ProductSpuTagPaginationDto());
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        paginationDto.setTenantCode(TenantUtils.getTenantCode());
        Page<ProductSpuTag> page = this.productSpuTagRepository.findByConditions(pageable, paginationDto);
        if (Objects.isNull(page) || CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return page;
        }
        Set tagCodeSet = page.getRecords().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTagCode())).map(ProductSpuTag::getTagCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(tagCodeSet)) {
            return page;
        }
        ProductSpuTagMappingQueryDto queryDto = new ProductSpuTagMappingQueryDto();
        queryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        queryDto.setTenantCode(TenantUtils.getTenantCode());
        queryDto.setTagCodes(tagCodeSet);
        List<ProductSpuTagMapping> list = this.productSpuTagMappingRepository.findByProductSpuTagMappingQueryDto(queryDto);
        Map<String, Long> map = list.stream().collect(Collectors.groupingBy(ProductSpuTagMapping::getTagCode, Collectors.counting()));
        for (ProductSpuTag item : page.getRecords()) {
            item.setSpuQuantity(map.getOrDefault(item.getTagCode(), 0L));
        }
        return page;
    }

    @Override
    @Transactional
    public ProductSpuTag create(ProductSpuTag productSpuTag) {
        this.createValidate(productSpuTag);
        if (StringUtils.isBlank((CharSequence)productSpuTag.getTagCode())) {
            String tagCode = (String)this.generateCodeService.generateCode("SP", 1).get(0);
            productSpuTag.setTagCode(tagCode);
        } else {
            ProductSpuTag old = this.productSpuTagRepository.findByTagCode(productSpuTag.getTagCode());
            Validate.isTrue((boolean)Objects.isNull((Object)old), (String)"\u5df2\u5b58\u5728\u5bf9\u5e94\u7f16\u7801\u7684\u6807\u7b7e", (Object[])new Object[0]);
        }
        productSpuTag.setTenantCode(TenantUtils.getTenantCode());
        this.productSpuTagRepository.save((Object)productSpuTag);
        return productSpuTag;
    }

    @Override
    @Transactional
    public ProductSpuTag update(ProductSpuTag productSpuTag) {
        this.updateValidate(productSpuTag);
        List<ProductSpuTag> list = this.productSpuTagRepository.findByIds(Lists.newArrayList((Object[])new String[]{productSpuTag.getId()}));
        ProductSpuTag first = list.stream().findFirst().orElse(null);
        Validate.notNull((Object)((Object)first), (String)"\u6807\u7b7e\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)productSpuTag.getTagCode().equals(first.getTagCode()), (String)"\u6807\u7b7e\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        this.productSpuTagRepository.updateByIdAndTenantCode(productSpuTag, TenantUtils.getTenantCode());
        return productSpuTag;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        this.productSpuTagRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE.getCode());
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        this.productSpuTagRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE.getCode());
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<ProductSpuTag> list = this.productSpuTagRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set<String> set = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTagCode())).map(ProductSpuTag::getTagCode).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(set)) {
            this.productSpuTagMappingRepository.deleteByTagCodes(set);
        }
        this.productSpuTagRepository.deleteBatch(ids);
    }

    @Override
    public ProductSpuTag findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        List<ProductSpuTag> list = this.productSpuTagRepository.findByIds(Lists.newArrayList((Object[])new String[]{id}));
        return list.stream().findFirst().orElse(null);
    }

    private void updateValidate(ProductSpuTag productSpuTag) {
        Validate.notNull((Object)((Object)productSpuTag), (String)"\u4fee\u6539\u5546\u54c1\u6807\u7b7e\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productSpuTag.getId(), (String)"\u4fee\u6539\u5546\u54c1\u6807\u7b7e\u65f6\uff0c\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productSpuTag.getTagName(), (String)"\u4fee\u6539\u5546\u54c1\u6807\u7b7e\u65f6\uff0c\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productSpuTag.getTagCode(), (String)"\u4fee\u6539\u5546\u54c1\u6807\u7b7e\u65f6\uff0c\u6807\u7b7e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductSpuTag tag = this.productSpuTagRepository.findByTagName(productSpuTag.getTagName());
        if (Objects.nonNull((Object)tag)) {
            Validate.isTrue((boolean)tag.getId().equals(productSpuTag.getId()), (String)"\u4fee\u6539\u5546\u54c1\u6807\u7b7e\u65f6\uff0c\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
        }
    }

    private void createValidate(ProductSpuTag productSpuTag) {
        Validate.notNull((Object)((Object)productSpuTag), (String)"\u521b\u5efa\u5546\u54c1\u6807\u7b7e\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        productSpuTag.setId(null);
        productSpuTag.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        productSpuTag.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Validate.notBlank((CharSequence)productSpuTag.getTagName(), (String)"\u521b\u5efa\u5546\u54c1\u6807\u7b7e\u65f6\uff0c\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductSpuTag tag = this.productSpuTagRepository.findByTagName(productSpuTag.getTagName());
        Validate.isTrue((tag == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u5546\u54c1\u6807\u7b7e\u65f6\uff0c\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
    }
}

