package com.biz.crm.mdm.business.product.spu.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * 可购清单spu分页请求dto
 *
 * @author sunx
 * @date 2021/12/6
 */
@Data
@ApiModel("可购清单spu分页请求dto")
public class AllowSaleListSpuPaginationDto {

  /** 业务编码,终端编码或客户编码 */
  @ApiModelProperty("业务编码，终端编码或客户编码")
  private String businessCode;

  /** 标签集合搜索过滤 */
  @ApiModelProperty("允销清单类型，终端或客户")
  private String listType;

  /** 搜索关键字，名称或编码 */
  @ApiModelProperty("搜索关键字，名称或编码")
  private String keyword;

  /** 产品层级 */
  @ApiModelProperty("产品层级，根据该过滤条件搜索当前及子级所有层级编码")
  private String productLevelCode;

  /** 标签集合搜索过滤 */
  @ApiModelProperty("标签集合搜索过滤，新品等")
  private List<String> spuTagList;

  /** 对应用户的可购清单全量的商品编码集合 */
  @ApiModelProperty(value = "对应用户的可购清单全量的商品编码集合", hidden = true)
  private List<String> productCodeList;

  /** 每页显示条数 */
  @ApiModelProperty(value = "每页显示条数")
  private Integer pageSize;

  /** 页码 */
  @ApiModelProperty(value = "页码")
  private Integer page;
}
