package com.biz.crm.mdm.business.product.spu.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 商品spu图片视频信息dto
 *
 * @author sunx
 * @date 2021-12-02 16:05:42
 */
@Data
@ApiModel(value = "ProductSpuMediaDto", description = "商品spu图片视频信息dto")
public class ProductSpuMediaDto extends TenantDto {

  /** 商品spu编码 */
  @ApiModelProperty("商品spu编码")
  private String spuCode;

  /** 图片视频地址 */
  @ApiModelProperty("图片视频地址")
  private String urlAddress;

  /** 文件类型，picture图片，video视频 */
  @ApiModelProperty("文件类型，picture图片，video视频")
  private String type;

  /** 文件名 */
  @ApiModelProperty("文件名")
  private String fileName;

  /** 原始文件名 */
  @ApiModelProperty("原始文件名")
  private String originalFileName;

  /** 文件路径 */
  @ApiModelProperty("文件路径")
  private String relativeLocal;
}
