package com.biz.crm.mdm.business.product.spu.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 商品spu标签信息dto
 *
 * @author sunx
 * @date 2021-12-02 17:06:54
 */
@Data
@ApiModel(value = "ProductSpuTagDto", description = "商品spu标签信息dto")
public class ProductSpuTagDto extends TenantDto {

  /**
   * 标签编码
   */
  @ApiModelProperty("标签编码")
  private String tagCode;

  /**
   * 标签名称
   */
  @ApiModelProperty("标签名称")
  private String tagName;

  /**
   * 标签icon
   */
  @ApiModelProperty("标签icon")
  private String tagUrl;

  /**
   * 标签描述
   */
  @ApiModelProperty("标签描述")
  private String tagDescription;

  /**
   * spu商品编码集合
   */
  @ApiModelProperty("spu商品编码集合")
  private List<String> spuCodes;
}
