package com.biz.crm.mdm.business.product.spu.sdk.event;

import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import java.util.List;

/**
 * 商品spu信息变更事件通知接口
 *
 * @author sunx
 * @date 2021-12-02 16:04:59
 */
public interface ProductSpuEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(ProductSpuVo vo) {}

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(ProductSpuVo oldVo, ProductSpuVo newVo) {}

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<ProductSpuVo> list) {}

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<ProductSpuVo> list) {}

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<ProductSpuVo> list) {}

  /**
   * 上架时触发
   *
   * @param voList
   */
  default void onUpShelf(List<ProductSpuVo> voList) {}

  /**
   * 下架时触发
   *
   * @param voList
   */
  default void onDownShelf(List<ProductSpuVo> voList) {}
}
