package com.biz.crm.mdm.business.product.spu.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: heguanyun
 * @Date: 2022/4/6 09:49
 * @description:收藏商品
 */
@Data
@ApiModel(value = "FavoriteProductVO", description = "收藏夹VO")
public class FavoriteProductVO {
    @ApiModelProperty("图片url")
    private String primaryPictureUrl;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("spu价格区间")
    private List<BigDecimal> priceShowList;

    @ApiModelProperty("库存数量")
    private int stockNum;

    @ApiModelProperty("销售单位")
    private String saleUnit;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("基本单位")
    private String baseUnit;

    @ApiModelProperty("sku集合")
    private List<FavoriteProductVO> skus;
}
