package com.biz.crm.mdm.business.product.spu.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品spu图片视频信息vo
 *
 * @author sunx
 * @date 2021-12-02 16:05:42
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商品spu图片视频信息Vo")
public class ProductSpuMediaVo extends TenantOpVo {

  /** 商品spu编码 */
  @ApiModelProperty("商品spu编码")
  private String spuCode;

  /** 图片视频地址 */
  @ApiModelProperty("图片视频地址")
  private String urlAddress;

  /** 文件类型，picture图片，video视频 */
  @ApiModelProperty("文件类型，picture图片，video视频")
  private String type;

  /** 文件名 */
  @ApiModelProperty("文件名")
  private String fileName;

  /** 原始文件名 */
  @ApiModelProperty("原始文件名")
  private String originalFileName;

  /** 文件路径 */
  @ApiModelProperty("文件路径")
  private String relativeLocal;
}
