package com.biz.crm.mdm.business.product.spu.sdk.service;

import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * spu关联sku sdk
 *
 * @author sunx
 * @date 2021/12/2
 */
public interface ProductSpuRelateSkuVoService {

  /**
   * 根据spuCode集合获取关联sku主要信息
   *
   * @param spuCodeList
   * @return
   */
  List<ProductSpuRelateSkuVo> findBySpuCodes(List<String> spuCodeList);

  /**
   * 根据productCode集合获取关联sku主要信息
   *
   * @param productCodeList
   * @return
   */
  default List<ProductSpuRelateSkuVo> findByProductCodes(List<String> productCodeList) {
    return Lists.newLinkedList();
  }


}
