package com.biz.crm.mdm.business.product.spu.sdk.service;

import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

/**
 * 商品spu信息Vo接口
 *
 * @author sunx
 * @date 2021-12-02 16:04:59
 */
public interface ProductSpuVoService {

  /**
   * 根据spuCode集合获取spu主信息
   *
   * @param spuCodeList
   * @return
   */
  List<ProductSpuVo> findBySpuCodes(List<String> spuCodeList);

  /**
   * 根据spuCode集合获取spu全量关联明细
   *
   * @param spuCodeList
   * @return
   */
  List<ProductSpuVo> findDetailsBySpuCodes(List<String> spuCodeList);

  /**
   * 根据商品编码获取关联的spu主信息
   *
   * @param productCodeList
   * @return
   */
  default Map<String, List<ProductSpuVo>> findRelateSpuMapByProductCodes(
      List<String> productCodeList) {
    return Maps.newHashMap();
  }
}
