package com.biz.crm.mdm.business.product.spu.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 商品spu关联的sku信息dto
 *
 * @author sunx
 * @date 2021-12-02 16:05:51
 */
@Data
@ApiModel(value = "ProductSpuRelateSkuDto", description = "商品spu关联的sku信息dto")
public class ProductSpuRelateSkuDto extends TenantDto {

  /** 商品spu编码 */
  @ApiModelProperty("商品spu编码")
  private String spuCode;

  /** 商品sku编码 */
  @ApiModelProperty("商品sku编码")
  private String productCode;

  /** 商品sku名称 */
  @ApiModelProperty("商品sku名称")
  private String productName;

  /** 商品sku类型 */
  @ApiModelProperty("商品sku类型")
  private String productType;

  /** 产品层级 */
  @ApiModelProperty("产品层级")
  private String productLevelName;

  /** 规格 */
  @ApiModelProperty("规格")
  private String spec;

  /** 上下架状态 */
  @ApiModelProperty("上下架状态")
  private String isShelf;
}
