package com.biz.crm.mdm.business.productlevel.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.mdm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.mdm.business.productlevel.sdk.enums.ProductLevelEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 产品层级实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductLevel", description = "产品层级实体")
@TableName("mdm_product_level")
@Entity
@Table(name = "mdm_product_level", indexes = {
    @Index(name = "MDM_PRODUCT_LEVEL_INDEX1", columnList = "product_level_code", unique = true),
    @Index(name = "MDM_PRODUCT_LEVEL_INDEX2", columnList = "parent_code"),
    @Index(name = "MDM_PRODUCT_LEVEL_INDEX3", columnList = "rule_code"),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_product_level", comment = "产品层级表")
public class ProductLevel extends TenantFlagTreeOpEntity {

  private static final long serialVersionUID = 8395261074854406320L;
  /**
   * 上级编码
   */
  @ApiModelProperty("上级编码")
  @TableField(value = "parent_code")
  @Column(name = "parent_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 上级编码 '")
  private String parentCode;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  @TableField(value = "product_level_code")
  @Column(name = "product_level_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 产品层级编码 '")
  private String productLevelCode;

  /**
   * 产品层级名称
   */
  @ApiModelProperty("产品层级名称")
  @TableField(value = "product_level_name")
  @Column(name = "product_level_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 产品层级名称 '")
  private String productLevelName;

  /**
   * 产品层级类型
   */
  @ApiModelProperty("产品层级类型")
  @TableField(value = "product_level_type")
  @Column(name = "product_level_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 产品层级类型 '")
  private ProductLevelEnum productLevelType;

}
