package com.biz.crm.mdm.business.productlevel.local.mapper;
/**
 * Created by Bao Hongbin on 2021-10-09 10:15.
 */

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.productlevel.local.entity.ProductLevel;
import com.biz.crm.mdm.business.productlevel.sdk.dto.ProductLevelPaginationDto;
import com.biz.crm.mdm.business.productlevel.sdk.vo.ProductLevelVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @program: crm
 * @description: 产品层级的mybatis-plus接口类
 * @author: Bao Hongbin
 * @create: 2021-10-09 10:15
 **/
public interface ProductLevelMapper extends BaseMapper<ProductLevel> {
  /**
   * 分页条件查询
   *
   * @param page
   * @param productLevelPaginationDto
   * @return
   */
  Page<ProductLevelVo> findByConditions(Page<ProductLevelVo> page,
                                        @Param("dto") ProductLevelPaginationDto productLevelPaginationDto);

  /**
   * 通过启用状态和RuleCodes模糊查询自身及子集
   *
   * @param ruleCodes
   * @param enableStatus
   * @param tenantCode
   * @return
   */
  List<ProductLevel> findCurAndChildrenByRuleCodeList(@Param("ruleCodes") List<String> ruleCodes,
                                                      @Param("enableStatus") String enableStatus,
                                                      @Param("tenantCode") String tenantCode);

  /**
   * 查找parentCode不为空但找不到对应上级的数据,设置parentCode为null
   *
   * @param tenantCode
   * @return
   */
  void updateOrphanParentCodeNull(@Param("tenantCode") String tenantCode);

  /**
   * 查询产品层级懒加载数据
   *
   * @param enableStatus    启用状态
   * @param topOnly         传true只查第一层
   * @param parentCode      只查询该编码下一级
   * @param codeList        只查询这些编码
   * @param ruleCodeList    只查询这些降维编码
   * @param excludeRuleCode 排除这个降维编码的下级
   * @param tenantCode
   * @return
   */
  List<LazyTreeVo> findLazyTreeList(@Param("enableStatus") String enableStatus,
                                    @Param("topOnly") Boolean topOnly,
                                    @Param("parentCode") String parentCode,
                                    @Param("codeList") List<String> codeList,
                                    @Param("ruleCodeList") List<String> ruleCodeList,
                                    @Param("excludeRuleCode") String excludeRuleCode,
                                    @Param("tenantCode") String tenantCode);
}
