package com.biz.crm.mdm.business.productlevel.local.service.internal;
/**
 * Created by Bao Hongbin on 2021-10-14 14:48.
 */

import com.biz.crm.mdm.business.productlevel.local.entity.ProductLevel;
import com.biz.crm.mdm.business.productlevel.local.repository.ProductLevelRepository;
import com.biz.crm.mdm.business.productlevel.local.service.ProductLevelVoService;
import com.biz.crm.mdm.business.productlevel.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.productlevel.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @program: crm
 * @description: 产品层级vo SDK 服务实现
 * @author: Bao Hongbin
 * @create: 2021-10-14 14:48
 **/
@Service
public class ProductLevelVoSdkServiceImpl implements ProductLevelVoSdkService {
  @Autowired
  private ProductLevelVoService productLevelVoService;
  @Autowired
  private ProductLevelRepository productLevelRepository;
  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public ProductLevelVo findDetailsById(String id) {
    return productLevelVoService.findDetailsById(id);
  }

  @Override
  public List<ProductLevelVo> findListByIds(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return new ArrayList<>();
    }
    List<ProductLevel> productLevels = productLevelRepository.findListByIds(ids, TenantUtils.getTenantCode());
    return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(productLevels, ProductLevel.class
        , ProductLevelVo.class, HashSet.class, ArrayList.class));
  }

  @Override
  public ProductLevelVo findDetailsByCode(String code) {
    if (StringUtils.isEmpty(code)) {
      return null;
    }
    ProductLevel productLevel = productLevelRepository.findDetailsByCode(code, TenantUtils.getTenantCode());
    if (null == productLevel) {
      return null;
    }
    return nebulaToolkitService.copyObjectByWhiteList(
        productLevel, ProductLevelVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public List<ProductLevelVo> findListByCodes(List<String> codes) {
    if (CollectionUtils.isEmpty(codes)) {
      return new ArrayList<>();
    }
    List<ProductLevel> productLevels = productLevelRepository.findListByCodes(codes, TenantUtils.getTenantCode());
    return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(productLevels, ProductLevel.class
        , ProductLevelVo.class, HashSet.class, ArrayList.class));
  }

  @Override
  public List<String> findCurAndChildrenCodesByCode(String productLevelCode) {
    return productLevelVoService.findCurAndChildrenCodesByCode(productLevelCode);
  }
}
