/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.productlevel.local.service.internal;

import com.biz.crm.mdm.business.productlevel.local.entity.ProductLevel;
import com.biz.crm.mdm.business.productlevel.local.repository.ProductLevelRepository;
import com.biz.crm.mdm.business.productlevel.local.service.ProductLevelVoService;
import com.biz.crm.mdm.business.productlevel.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.productlevel.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ProductLevelVoSdkServiceImpl
implements ProductLevelVoSdkService {
    @Autowired
    private ProductLevelVoService productLevelVoService;
    @Autowired
    private ProductLevelRepository productLevelRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public ProductLevelVo findDetailsById(String id) {
        return this.productLevelVoService.findDetailsById(id);
    }

    public List<ProductLevelVo> findListByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ProductLevelVo>();
        }
        List<ProductLevel> productLevels = this.productLevelRepository.findListByIds(ids, TenantUtils.getTenantCode());
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(productLevels, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public ProductLevelVo findDetailsByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        ProductLevel productLevel = this.productLevelRepository.findDetailsByCode(code, TenantUtils.getTenantCode());
        if (null == productLevel) {
            return null;
        }
        return (ProductLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)productLevel, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ProductLevelVo> findListByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<ProductLevelVo>();
        }
        List<ProductLevel> productLevels = this.productLevelRepository.findListByCodes(codes, TenantUtils.getTenantCode());
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(productLevels, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<String> findCurAndChildrenCodesByCode(String productLevelCode) {
        return this.productLevelVoService.findCurAndChildrenCodesByCode(productLevelCode);
    }
}

