/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.productlevel.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.productlevel.local.entity.ProductLevel;
import com.biz.crm.mdm.business.productlevel.local.repository.ProductLevelRepository;
import com.biz.crm.mdm.business.productlevel.local.service.ProductLevelVoService;
import com.biz.crm.mdm.business.productlevel.local.service.helper.ProductLevelServiceHelper;
import com.biz.crm.mdm.business.productlevel.sdk.dto.ProductLevelCreateDto;
import com.biz.crm.mdm.business.productlevel.sdk.dto.ProductLevelPaginationDto;
import com.biz.crm.mdm.business.productlevel.sdk.dto.ProductLevelUpdateDto;
import com.biz.crm.mdm.business.productlevel.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ProductLevelVoServiceImpl
implements ProductLevelVoService {
    @Autowired
    private ProductLevelRepository productLevelRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private GenerateCodeService generateCode;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
    @Autowired
    private ProductLevelServiceHelper helper;

    @Override
    public Page<ProductLevelVo> findByConditions(Pageable pageable, ProductLevelPaginationDto productLevelPaginationDto) {
        ProductLevel one;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        productLevelPaginationDto = Optional.ofNullable(productLevelPaginationDto).orElse(new ProductLevelPaginationDto());
        productLevelPaginationDto.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isNotEmpty((CharSequence)productLevelPaginationDto.getUnderProductLevelCode()) && (one = this.productLevelRepository.findDetailsByCode(productLevelPaginationDto.getUnderProductLevelCode(), productLevelPaginationDto.getTenantCode())) != null) {
            productLevelPaginationDto.setUnderThisRuleCode(one.getRuleCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)productLevelPaginationDto.getNotUnderProductLevelCode()) && (one = this.productLevelRepository.findDetailsByCode(productLevelPaginationDto.getNotUnderProductLevelCode(), productLevelPaginationDto.getTenantCode())) != null) {
            productLevelPaginationDto.setNotUnderThisRuleCode(one.getRuleCode());
        }
        List selectedCodeList = Optional.ofNullable(productLevelPaginationDto.getSelectedCodeList()).orElse(new ArrayList());
        if (StringUtils.isNotEmpty((CharSequence)productLevelPaginationDto.getSelectedCode())) {
            selectedCodeList.add(productLevelPaginationDto.getSelectedCode());
        }
        if (!CollectionUtils.isEmpty((Collection)selectedCodeList)) {
            productLevelPaginationDto.setSelectedCodeList(selectedCodeList);
        }
        return this.productLevelRepository.findByConditions(pageable, productLevelPaginationDto);
    }

    @Override
    public ProductLevelVo findDetailsById(String id) {
        ProductLevel parent;
        if (!StringUtils.isNotEmpty((CharSequence)id)) {
            return null;
        }
        ProductLevel one = this.productLevelRepository.findDetailsById(id, TenantUtils.getTenantCode());
        if (one == null) {
            return null;
        }
        ProductLevelVo respVo = (ProductLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)one, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (StringUtils.isNotEmpty((CharSequence)one.getParentCode()) && (parent = this.productLevelRepository.findDetailsByCode(one.getParentCode(), TenantUtils.getTenantCode())) != null) {
            respVo.setParentName(parent.getProductLevelName());
        }
        return respVo;
    }

    @Override
    @Transactional
    public ProductLevelVo create(ProductLevelCreateDto productLevelCreateDto) {
        return this.createForm(productLevelCreateDto);
    }

    @Override
    @Transactional
    public ProductLevelVo update(ProductLevelUpdateDto productLevelUpdateDto) {
        return this.updateForm(productLevelUpdateDto);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f53\u8fdb\u884c\u542f\u7528\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        List<ProductLevel> productLevelList = this.productLevelRepository.findListByIds(ids, TenantUtils.getTenantCode()).stream().filter(x -> !EnableStatusEnum.ENABLE.getCode().equals(x.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(productLevelList)) {
            return;
        }
        List collect = productLevelList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Set parentRuleCodesExcludeSelf = treeRuleCodeStrategy.findParentRuleCodeByRuleCodesExcludeAnySelf(3, collect);
        if (!parentRuleCodesExcludeSelf.isEmpty()) {
            List parentList = this.productLevelRepository.findListByRuleCodes(parentRuleCodesExcludeSelf, TenantUtils.getTenantCode()).stream().filter(x -> !EnableStatusEnum.ENABLE.getCode().equals(x.getEnableStatus())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(parentList), (String)"\u5b58\u5728\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u5c42\u7ea7\uff0c\u4e0d\u80fd\u542f\u7528\u5f53\u524d\u5c42\u7ea7", (Object[])new Object[0]);
        }
        productLevelList.forEach(productLevel -> productLevel.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
        this.productLevelRepository.updateBatchById(productLevelList);
        ArrayList productLevelVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(productLevelList, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]));
        this.helper.sendEnableEvent(productLevelVos);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f53\u8fdb\u884c\u7981\u7528\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        List<ProductLevel> productLevelList = this.productLevelRepository.findListByIds(ids, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(productLevelList)) {
            return;
        }
        List<String> ruleCodes = productLevelList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
        List<ProductLevel> childrenByRuleCodeList = this.productLevelRepository.findCurAndChildrenByRuleCodeList(ruleCodes, EnableStatusEnum.ENABLE.getCode(), TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(childrenByRuleCodeList)) {
            childrenByRuleCodeList.forEach(productLevel -> productLevel.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
            this.productLevelRepository.updateBatchById(childrenByRuleCodeList);
            ArrayList productLevelVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrenByRuleCodeList, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.helper.sendDisableEvent(productLevelVos);
        }
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f53\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        List<ProductLevel> productLevelList = this.productLevelRepository.findListByIds(ids, TenantUtils.getTenantCode());
        Validate.isTrue((!CollectionUtils.isEmpty(productLevelList) ? 1 : 0) != 0, (String)"\u65e0\u6548\u7684\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        List<String> productLevelCodeList = productLevelList.stream().map(ProductLevel::getProductLevelCode).collect(Collectors.toList());
        List childrenList = this.productLevelRepository.findChildrenListByParentCodes(productLevelCodeList, TenantUtils.getTenantCode()).stream().filter(o -> !ids.contains(o.getId())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(childrenList), (String)"\u5f53\u524d\u4ea7\u54c1\u5c42\u7ea7\u5305\u542b\u5b50\u5c42\u7ea7\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u82e5\u9700\u8981\u5220\u9664\u8bf7\u5148\u5220\u9664\u5b50\u5c42\u7ea7", (Object[])new Object[0]);
        this.productLevelRepository.removeByIds(ids);
        ArrayList productLevelVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(productLevelList, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]));
        this.helper.sendDeleteEvent(productLevelVos);
    }

    @Override
    @Transactional
    public void updateRuleCode() {
        this.productLevelRepository.updateOrphanParentCodeNull(TenantUtils.getTenantCode());
        List<ProductLevel> topList = this.productLevelRepository.findListWithoutParentCode(TenantUtils.getTenantCode());
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        for (int i = 0; i < topList.size(); ++i) {
            this.updateCurAndChildrenRuleCode(topList.get(i).getProductLevelCode(), treeRuleCodeStrategy.generateByNum(3, i + 1), 1);
        }
    }

    @Override
    public List<String> findCurAndChildrenCodesByCode(String productLevelCode) {
        if (StringUtils.isBlank((CharSequence)productLevelCode)) {
            return new ArrayList<String>();
        }
        ProductLevel productLevel = this.productLevelRepository.findDetailsByCode(productLevelCode, TenantUtils.getTenantCode());
        if (null == productLevel) {
            return new ArrayList<String>();
        }
        return this.productLevelRepository.findCurAndChildrenByRuleCode(productLevel.getRuleCode(), TenantUtils.getTenantCode()).stream().map(ProductLevel::getProductLevelCode).collect(Collectors.toList());
    }

    @Override
    public List<ProductLevelVo> findAll() {
        List<ProductLevel> all = this.productLevelRepository.findAll(TenantUtils.getTenantCode());
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(all, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    private ProductLevelVo createForm(ProductLevelCreateDto productLevelCreateDto) {
        this.helper.createValidation(productLevelCreateDto);
        ProductLevel productLevel = (ProductLevel)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)productLevelCreateDto, ProductLevel.class, HashSet.class, ArrayList.class, new String[0]));
        productLevel.setTenantCode(TenantUtils.getTenantCode());
        productLevel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        productLevel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isBlank((CharSequence)productLevelCreateDto.getProductLevelCode())) {
            productLevel.setProductLevelCode((String)this.generateCode.generateCode("CPCJ", 1).get(0));
        }
        int levelNum = 1;
        if (StringUtils.isNotEmpty((CharSequence)productLevelCreateDto.getParentCode())) {
            ProductLevel parent = this.productLevelRepository.findDetailsByCode(productLevelCreateDto.getParentCode(), TenantUtils.getTenantCode());
            levelNum = parent.getLevelNum() + 1;
        }
        String ruleCode = this.getRuleCodeByParentCode(productLevelCreateDto.getParentCode());
        productLevel.setRuleCode(ruleCode);
        productLevel.setLevelNum(levelNum);
        this.productLevelRepository.save((Object)productLevel);
        ProductLevelVo productLevelVo = (ProductLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)productLevel, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.helper.sendCreateEvent(Collections.singletonList(productLevelVo));
        return productLevelVo;
    }

    private ProductLevelVo updateForm(ProductLevelUpdateDto productLevelUpdateDto) {
        this.helper.updateValidation(productLevelUpdateDto);
        ProductLevel productLevel = this.productLevelRepository.findDetailsById(productLevelUpdateDto.getId(), TenantUtils.getTenantCode());
        int levelNum = 1;
        if (StringUtils.isNotEmpty((CharSequence)productLevelUpdateDto.getParentCode())) {
            ProductLevel parent = this.productLevelRepository.findDetailsByCode(productLevelUpdateDto.getParentCode(), TenantUtils.getTenantCode());
            levelNum = parent.getLevelNum() + 1;
        }
        ProductLevel productLevelNew = (ProductLevel)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)productLevelUpdateDto, ProductLevel.class, HashSet.class, ArrayList.class, new String[0]));
        this.productLevelRepository.updateById((Object)productLevelNew);
        boolean updateRuleCode = false;
        String enableStatusChangeTo = "";
        if (!(productLevel.getParentCode() == null ? "" : productLevel.getParentCode()).equals(productLevelUpdateDto.getParentCode() == null ? "" : productLevelUpdateDto.getParentCode())) {
            updateRuleCode = true;
        }
        if (!productLevel.getEnableStatus().equals(productLevelUpdateDto.getEnableStatus())) {
            enableStatusChangeTo = productLevelUpdateDto.getEnableStatus();
        }
        if (updateRuleCode) {
            String ruleCode = this.getRuleCodeByParentCode(productLevelUpdateDto.getParentCode());
            this.updateCurAndChildrenRuleCode(productLevelNew.getProductLevelCode(), ruleCode, levelNum);
        }
        if (StringUtils.isNotEmpty((CharSequence)enableStatusChangeTo)) {
            if (EnableStatusEnum.ENABLE.getCode().equals(enableStatusChangeTo)) {
                this.enableBatch(Collections.singletonList(productLevelNew.getId()));
            } else if (EnableStatusEnum.DISABLE.getCode().equals(enableStatusChangeTo)) {
                this.disableBatch(Collections.singletonList(productLevelNew.getId()));
            } else {
                throw new IllegalArgumentException("\u542f\u7528\u72b6\u6001\u9519\u8bef");
            }
        }
        productLevel = this.productLevelRepository.findDetailsById(productLevelUpdateDto.getId(), TenantUtils.getTenantCode());
        ProductLevelVo productLevelVo = (ProductLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)productLevel, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.helper.sendUpdateEvent(Collections.singletonList(productLevelVo));
        return productLevelVo;
    }

    private String getRuleCodeByParentCode(String parentCode) {
        String parentRuleCode = null;
        if (StringUtils.isNotEmpty((CharSequence)parentCode)) {
            ProductLevel parent = this.productLevelRepository.findDetailsByCode(parentCode, TenantUtils.getTenantCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            parentRuleCode = parent.getRuleCode();
        }
        List<ProductLevel> childrenListByParentCode = this.productLevelRepository.findChildrenListByParentCode(parentCode, TenantUtils.getTenantCode());
        ArrayList childrenDto = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrenListByParentCode, ProductLevel.class, TreeDto.class, HashSet.class, ArrayList.class, new String[0]));
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        return treeRuleCodeStrategy.generate(3, parentRuleCode, (List)childrenDto);
    }

    private void updateCurAndChildrenRuleCode(String productLevelCode, String ruleCode, int levelNum) {
        ProductLevel productLevel = this.productLevelRepository.findDetailsByCode(productLevelCode, TenantUtils.getTenantCode());
        productLevel.setRuleCode(ruleCode);
        productLevel.setLevelNum(levelNum);
        this.productLevelRepository.updateById((Object)productLevel);
        List<ProductLevel> childrenList = this.productLevelRepository.findChildrenListByParentCode(productLevelCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(childrenList)) {
            return;
        }
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        for (int i = 0; i < childrenList.size(); ++i) {
            this.updateCurAndChildrenRuleCode(childrenList.get(i).getProductLevelCode(), ruleCode + treeRuleCodeStrategy.generateByNum(3, i + 1), levelNum + 1);
        }
    }
}

